/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.propertieseditor.bundlemodel;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.propertieseditor.bundlemodel.PropertyModel;

public class BundleModel {
    IFile main;
    XModelObject object = PreferenceModelUtilities.getPreferenceModel().createModelObject("FilePROPERTIES", null);
    String currentLocale = "";
    Set<String> locales = new TreeSet<String>();
    Set<String> removedLocales = new HashSet<String>();
    boolean isModified;
    ModificationListener modificationListener;

    public void dispose() {
        this.modificationListener = null;
        if (this.locales != null) {
            this.locales.clear();
        }
        this.locales = null;
        if (this.removedLocales != null) {
            this.removedLocales.clear();
        }
        this.removedLocales = null;
        this.main = null;
    }

    public void setMainFile(IFile f) {
        this.main = f;
    }

    public String getName() {
        String name = this.main.getName();
        if (name.endsWith(".properties")) {
            name = name.substring(0, name.length() - ".properties".length());
        }
        return name;
    }

    public IFile getMainFile() {
        return this.main;
    }

    public XModelObject getModelObject() {
        return this.object;
    }

    public IFile getFile(String locale) {
        if (locale.length() == 0) {
            return this.main;
        }
        String name = String.valueOf(this.getName()) + "_" + locale + ".properties";
        return this.main.getParent().getFile((IPath)new Path("/" + name));
    }

    public String[] getLocales() {
        return this.locales.toArray(new String[0]);
    }

    public void setCurrentLocale(String locale) {
        this.currentLocale = locale;
        PropertyModel[] ps = this.getPropertyModelArray();
        int i = 0;
        while (i < ps.length) {
            ps[i].setLocale(locale);
            ++i;
        }
    }

    public PropertyModel[] getPropertyModelArray() {
        XModelObject[] cs = this.object.getChildren();
        PropertyModel[] ps = new PropertyModel[cs.length];
        int i = 0;
        while (i < ps.length) {
            ps[i] = this.getPropertyModel(cs[i], this.currentLocale);
            ++i;
        }
        return ps;
    }

    public PropertyModel createPropertyModel(String name, String value, String locale) {
        XModelObject o = PreferenceModelUtilities.getPreferenceModel().createModelObject("Property", null);
        o.setAttributeValue("name", name);
        o.setAttributeValue("value", value);
        this.object.addChild(o);
        return this.getPropertyModel(o, locale);
    }

    public PropertyModel getPropertyModel(String name) {
        return this.getPropertyModel(this.object.getChildByPath(name), this.currentLocale);
    }

    public PropertyModel getPropertyModel(XModelObject o, String locale) {
        if (o == null) {
            return null;
        }
        PropertyModel pm = (PropertyModel)o.getObject("propertyModel");
        if (pm == null) {
            pm = new PropertyModel(this);
            pm.setModelObject(o);
            if (locale != null) {
                pm.setValue(locale, o.getAttributeValue("value"));
            }
            pm.setLocale(this.currentLocale);
        }
        return pm;
    }

    public String getCurrentLocale() {
        return this.currentLocale;
    }

    public void load() {
        this.locales.clear();
        this.removedLocales.clear();
        this.locales.add("");
        String name = this.getName();
        String[][] p = this.loadFile(this.main);
        if (p == null) {
            return;
        }
        int i = 0;
        while (i < p.length) {
            this.createPropertyModel(p[i][0], p[i][1], "");
            ++i;
        }
        IResource[] rs = new IResource[]{};
        try {
            rs = this.main.getParent().members();
        }
        catch (CoreException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        int i2 = 0;
        while (i2 < rs.length) {
            if (rs[i2] instanceof IFile) {
                IFile f = (IFile)rs[i2];
                String nm = rs[i2].getLocation().lastSegment().toString();
                if (nm.startsWith(name) && nm.endsWith(".properties") && nm.indexOf("_") >= 0) {
                    nm = nm.substring(0, nm.length() - ".properties".length());
                    String locale = nm.substring(nm.indexOf("_") + 1);
                    this.locales.add(locale);
                    p = this.loadFile(f);
                    if (p != null) {
                        int j = 0;
                        while (j < p.length) {
                            PropertyModel pm = this.getPropertyModel(p[j][0]);
                            if (pm == null) {
                                pm = this.createPropertyModel(p[j][0], p[j][1], locale);
                            } else {
                                pm.setValue(locale, p[j][1]);
                            }
                            ++j;
                        }
                    }
                }
            }
            ++i2;
        }
    }

    /*
     * Unable to fully structure code
     */
    private String[][] loadFile(IFile file) {
        block25: {
            if (!file.exists()) {
                return null;
            }
            keys = new ArrayList<String>();
            values = new ArrayList<String>();
            p = new Properties();
            s = null;
            try {
                s = file.getContents();
                in = new BufferedReader(new InputStreamReader(s, "8859_1"));
                while ((line = in.readLine()) != null) {
                    if (line.length() == 0 || (firstChar = line.charAt(0)) == '#' || firstChar == '!') continue;
                    sb = new StringBuffer(line);
                    while (this.continueLine(line)) {
                        nextLine = in.readLine();
                        if (nextLine == null) {
                            nextLine = "";
                        }
                        sb.append("\n");
                        line = nextLine;
                        sb.append(line);
                    }
                    is = new ByteArrayInputStream(sb.toString().getBytes());
                    p.clear();
                    try {
                        p.load(is);
                    }
                    catch (IllegalArgumentException v0) {
                    }
                    catch (IOException e) {
                        ModelUIPlugin.getPluginLog().logError((Throwable)e);
                    }
                    if (!(ee = p.keys()).hasMoreElements()) continue;
                    key = ee.nextElement().toString();
                    keys.add(key);
                    values.add(p.getProperty(key));
                }
            }
            catch (CoreException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (IOException v1) {}
                }
                break block25;
            }
            catch (IOException e) {
                try {
                    ModelUIPlugin.getPluginLog().logError((Throwable)e);
                    ** if (s == null) goto lbl-1000
                }
                catch (Throwable var13_17) {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (IOException v3) {}
                    }
                    throw var13_17;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        s.close();
                    }
                    catch (IOException v2) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block25;
                }
            }
            if (s == null) break block25;
            try {
                s.close();
            }
            catch (IOException v4) {}
        }
        r = new String[keys.size()][2];
        i = 0;
        while (i < r.length) {
            r[i][0] = ((String)keys.get(i)).toString();
            r[i][1] = ((String)values.get(i)).toString();
            ++i;
        }
        return r;
    }

    private boolean continueLine(String line) {
        int slashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 == 1;
    }

    public void addLocale(String locale) {
        if (!this.locales.contains(locale)) {
            this.locales.add(locale);
            this.removedLocales.remove(locale);
            this.setModified(true);
        }
        this.setCurrentLocale(locale);
    }

    public void removeLocale(String locale) {
        if (locale.length() == 0 || !this.locales.contains(locale)) {
            return;
        }
        this.locales.remove(locale);
        this.removedLocales.add(locale);
        this.setModified(true);
    }

    public void save() {
        IFile f;
        String[] ls = this.removedLocales.toArray(new String[0]);
        int i = 0;
        while (i < ls.length) {
            f = this.getFile(ls[i]);
            if (f.exists()) {
                try {
                    f.delete(true, true, null);
                }
                catch (CoreException e) {
                    ModelUIPlugin.getPluginLog().logError((Throwable)e);
                }
            }
            ++i;
        }
        this.removedLocales.clear();
        ls = this.locales.toArray(new String[0]);
        i = 0;
        while (i < ls.length) {
            f = this.getFile(ls[i]);
            StringBuffer sb = new StringBuffer();
            PropertyModel[] ps = this.getPropertyModelArray();
            int k = 0;
            while (k < ps.length) {
                block14: {
                    String key = ps[k].getName();
                    String value = ps[k].getValue(ls[i]);
                    if (ps[k].hasValue(ls[i])) {
                        Properties p0 = new Properties();
                        p0.setProperty(key, value);
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        try {
                            p0.store(os, null);
                        }
                        catch (IOException e) {
                            ModelUIPlugin.getPluginLog().logError((Throwable)e);
                            break block14;
                        }
                        String s = os.toString();
                        if (s.startsWith("#")) {
                            s = s.substring(s.indexOf(10) + 1);
                        }
                        sb.append(s);
                    }
                }
                ++k;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(sb.toString().getBytes());
            try {
                if (f.exists()) {
                    f.setContents((InputStream)is, true, true, null);
                } else {
                    f.create((InputStream)is, true, null);
                }
            }
            catch (CoreException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
            }
            ++i;
        }
        this.setModified(false);
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void setModified(boolean b) {
        if (this.isModified == b) {
            return;
        }
        this.isModified = b;
        if (this.modificationListener != null) {
            this.modificationListener.changed();
        }
    }

    public void addModifiedListener(ModificationListener listener) {
        this.modificationListener = listener;
    }

    public void removeModifiedListener(ModificationListener listener) {
        this.modificationListener = null;
    }

    public boolean isEditable() {
        IFile f = this.getFile(this.currentLocale);
        if (f == null || !f.exists()) {
            return true;
        }
        return !f.isReadOnly();
    }

    public static interface ModificationListener {
        public void changed();
    }
}

