/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.propertieseditor.text;

import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.loaders.impl.PropertiesLoader;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.texteditors.TextEditorSupport;
import org.jboss.tools.common.propertieseditor.PropertiesCompoundEditor;

public class PropertyTextEditorSupport
extends TextEditorSupport {
    PropertiesLoader loader = new PropertiesLoader();

    @Override
    protected String loadContent() {
        XModelObject o = this.getModelObject();
        if (PropertiesCompoundEditor.isPropertiesFile(o)) {
            return this.loader.getBody(o);
        }
        if (o instanceof FileAnyImpl) {
            return ((FileAnyImpl)o).getAsText();
        }
        return o == null ? "" : this.loader.getBody(o);
    }

    @Override
    public void save() {
        if (this.lock > 0 || !this.isModified()) {
            return;
        }
        ++this.lock;
        try {
            try {
                XModelObject o = this.getModelObject();
                if (PropertiesCompoundEditor.isPropertiesFile(o)) {
                    this.loader.edit(this.getModelObject(), this.provider.getText());
                } else if (o instanceof FileAnyImpl) {
                    ((FileAnyImpl)o).edit(this.provider.getText());
                }
            }
            catch (XModelException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
                --this.lock;
                this.setModified(false);
            }
        }
        finally {
            --this.lock;
            this.setModified(false);
        }
    }
}

