/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.action;

import java.util.Hashtable;
import org.jboss.tools.common.meta.action.SignificanceMessage;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.meta.action.impl.SignificanceMessageImpl;
import org.jboss.tools.common.meta.action.impl.handlers.ReplaceSignificanceMessageImpl;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.ModelFeatureFactory;

public class SignificanceMessageFactory {
    public static final String MESSAGE_CLASS_NAME_PARAMETER = "significanceMessageClass";
    private static SignificanceMessage defaultFactory = new SignificanceMessageImpl();
    private static SignificanceMessage defaultReplaceFactory = new ReplaceSignificanceMessageImpl();
    private static Hashtable map = new Hashtable();

    private SignificanceMessageFactory() {
    }

    public static SignificanceMessageFactory getInstance() {
        return SignificanceMessageFactoryHolder.instance;
    }

    public String getMessage(XAction action, XModelObject object, XModelObject[] objects) {
        String ms = action.getProperty(MESSAGE_CLASS_NAME_PARAMETER);
        if (ms == null || ms.length() == 0) {
            return defaultFactory.getMessage(action, object, objects);
        }
        if ("%Replace%".equals(ms)) {
            return defaultReplaceFactory.getMessage(action, object, objects);
        }
        SignificanceMessage specificMessage = (SignificanceMessage)map.get(ms);
        if (specificMessage == null) {
            specificMessage = this.getImplInstance(ms);
        }
        return specificMessage.getMessage(action, object, objects);
    }

    private SignificanceMessage getImplInstance(String clsname) {
        try {
            return (SignificanceMessage)ModelFeatureFactory.getInstance().createFeatureInstance(clsname);
        }
        catch (ClassCastException t) {
            ModelPlugin.getPluginLog().logError((Throwable)t);
            return defaultFactory;
        }
    }

    /* synthetic */ SignificanceMessageFactory(SignificanceMessageFactory significanceMessageFactory) {
        this();
    }

    static class SignificanceMessageFactoryHolder {
        static SignificanceMessageFactory instance = new SignificanceMessageFactory(null);

        SignificanceMessageFactoryHolder() {
        }
    }
}

