/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems;

import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileSystemsImpl;
import org.jboss.tools.common.model.filesystems.impl.Libs;

public class FileSystemsHelper {
    public static final String FILE_SYSTEMS = "FileSystems";

    public static XModelObject getFileSystems(XModel model) {
        return model == null ? null : model.getByPath(FILE_SYSTEMS);
    }

    public static XModelObject getFileSystem(XModel model, String name) {
        return model.getByPath("FileSystems/" + name);
    }

    public static XModelObject getWebRoot(XModel model) {
        return model.getByPath("FileSystems/WEB-ROOT");
    }

    public static XModelObject getWebInf(XModel model) {
        return model.getByPath("FileSystems/WEB-INF");
    }

    public static Libs getLibs(XModel model) {
        XModelObject fs = FileSystemsHelper.getFileSystems(model);
        return !(fs instanceof FileSystemsImpl) ? null : ((FileSystemsImpl)fs).getLibs();
    }

    public static Libs getLibs(XModelObject object) {
        if (object instanceof FileSystemsImpl) {
            return ((FileSystemsImpl)object).getLibs();
        }
        return object == null ? null : FileSystemsHelper.getLibs(object.getModel());
    }

    public static XModelObject getFile(XModelObject o) {
        while (o != null && o.getFileType() != 1) {
            o = o.getParent();
        }
        return o;
    }
}

