/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import java.io.File;
import java.util.Hashtable;
import org.jboss.tools.common.model.filesystems.FilePathHelper;

public class FileSystemPeer {
    private Hashtable<String, Info> p = new Hashtable();

    public void clear() {
        this.p.clear();
    }

    public void register(File f) {
        this.p.put(this.toKey(f), new Info(f));
    }

    public void unregister(File f) {
        this.p.remove(this.toKey(f));
    }

    public void unregisterDir(File f) {
        this.p.remove(this.toKey(f, true));
    }

    public boolean contains(File f) {
        return this.p.containsKey(this.toKey(f));
    }

    public boolean containsDir(File f) {
        return this.p.containsKey(this.toKey(f, true));
    }

    public boolean isUpdated(File f) {
        Info o = this.p.get(this.toKey(f));
        return o == null ? f.exists() : o.changed(f);
    }

    private String toKey(File f) {
        return this.toKey(f, f.isDirectory());
    }

    private String toKey(File f, boolean asDir) {
        String s = f.getAbsolutePath().replace('\\', '/');
        s = FilePathHelper.toPathPath(s);
        return asDir ? String.valueOf(s) + "/" : s;
    }

    class Info {
        long lastModified;
        long length;

        Info(File f) {
            this.lastModified = f.lastModified();
            this.length = f.length();
        }

        public boolean equals(Info other) {
            return this.lastModified != other.lastModified || this.length != other.length;
        }

        public boolean equals(File other) {
            return this.lastModified != other.lastModified() || this.length != other.length();
        }

        public boolean changed(File f) {
            return this.equals(f);
        }
    }
}

