/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.jboss.tools.common.model.filesystems.impl.JarAccess;
import org.jboss.tools.common.model.filesystems.impl.JarSystemImpl;

public class JarAccessFactory {
    private static Map<String, JarAccess> jars = new HashMap<String, JarAccess>();

    static {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new WorkspaceListener());
    }

    public static synchronized JarAccess getJarAccess(String location, JarSystemImpl context) {
        JarAccess jar = jars.get(location);
        if (jar == null) {
            jar = new JarAccess();
            jar.setMain(context);
            jar.setLocation(location);
            jars.put(location, jar);
        }
        if (context != jar.getMain()) {
            jar.addSlave(context);
        }
        return jar;
    }

    private static synchronized void onProjectDelete(IProject project) {
        for (JarAccess jar : jars.values()) {
            jar.onProjectDelete(project);
        }
    }

    static class WorkspaceListener
    implements IResourceChangeListener {
        WorkspaceListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() == 4 && event.getResource() instanceof IProject) {
                JarAccessFactory.onProjectDelete((IProject)event.getResource());
            }
        }
    }
}

