/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import java.text.MessageFormat;
import java.util.Properties;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultRemoveHandler;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileSystemsImpl;
import org.jboss.tools.common.model.filesystems.impl.MountFileSystemHandler;
import org.jboss.tools.common.model.filesystems.impl.UnmountFileSystemUndo;
import org.jboss.tools.common.model.loaders.XObjectLoader;
import org.jboss.tools.common.model.plugin.ModelMessages;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;

public class UnmountFileSystemHandler
extends DefaultRemoveHandler {
    @Override
    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        if (!this.isEnabled(object)) {
            return;
        }
        if (!this.handleModified(object)) {
            return;
        }
        XModelObject parent = object.getParent();
        object.removeFromParent();
        object.getModel().getUndoManager().addUndoable(new UnmountFileSystemUndo(object));
        parent.setModified(true);
        if (parent instanceof FileSystemsImpl) {
            ((FileSystemsImpl)parent).updateOverlapped();
        }
        MountFileSystemHandler.updateClassPath(object);
    }

    @Override
    public boolean isEnabled(XModelObject object) {
        return false;
    }

    @Override
    public boolean getSignificantFlag(XModelObject object) {
        return object != null && !object.isModified();
    }

    private boolean handleModified(XModelObject object) {
        if (!object.isModified()) {
            return true;
        }
        ServiceDialog d = object.getModel().getService();
        String mes = MessageFormat.format("File system {0} was modified.\nDo you want to save changes?", object.get("NAME"));
        int i = d.showDialog(this.action.getDisplayName(), mes, new String[]{ModelMessages.Yes, ModelMessages.No, ModelMessages.Cancel}, null, 0);
        if (i == 1) {
            return true;
        }
        if (i != 0) {
            return false;
        }
        XObjectLoader loader = XModelObjectLoaderUtil.getObjectLoader(object);
        return loader == null || loader.save(object);
    }
}

