/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.impl;

import java.text.MessageFormat;
import java.util.Comparator;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XChild;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.XOrderedObject;
import org.jboss.tools.common.model.impl.EntityComparator;
import org.jboss.tools.common.model.impl.RegularChildren;
import org.jboss.tools.common.model.impl.XModelObjectImpl;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;

public class RegularObjectImpl
extends XModelObjectImpl
implements XOrderedObject {
    private static final long serialVersionUID = 7942041044569562286L;
    protected RegularChildren children = null;

    protected RegularChildren createChildren() {
        return new RegularChildren();
    }

    @Override
    public void destroy() {
        if (this.children != null && !this.children.isEmpty()) {
            XModelObject[] h;
            XModelObject[] xModelObjectArray = h = this.children.getObjects();
            int n = h.length;
            int n2 = 0;
            while (n2 < n) {
                XModelObject o = xModelObjectArray[n2];
                ((XModelObjectImpl)o).destroy();
                ++n2;
            }
            this.children = this.createChildren();
        }
        super.destroy();
    }

    @Override
    public boolean areChildrenOrdered() {
        return this.children != null && this.children.areChildrenOrdered();
    }

    @Override
    public String name() {
        return this.get("NAME");
    }

    @Override
    protected void onSetEntity(String name) {
        super.onSetEntity(name);
        if (this.children == null) {
            this.children = this.createChildren();
        }
        this.children.clear();
        this.children.setComparator(this.createComparator());
    }

    protected Comparator<XModelObject> createComparator() {
        return EntityComparator.getComparator(this.getModelEntity());
    }

    @Override
    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    protected void loadChildren() {
    }

    @Override
    public XModelObject[] getChildren() {
        this.loadChildren();
        return this.children.getObjects();
    }

    @Override
    public XModelObject[] getLoadedChildren() {
        return this.children.getObjects();
    }

    @Override
    public boolean addChild_0(XModelObject o) {
        if (o == null) {
            return false;
        }
        String entity = o.getModelEntity().getName();
        XChild c = this.getModelEntity().getChild(entity);
        if (c == null) {
            return false;
        }
        if (c.getMaxCount() < Integer.MAX_VALUE && this.children.getChildrenCount(entity) >= c.getMaxCount()) {
            return false;
        }
        ((XModelObjectImpl)o).setParent_0(this);
        boolean b = this.children.addObject(o);
        if (b) {
            if (o.getErrorState() == 2 || o.getErrorChildCount() > 0) {
                this.registerErrorChild();
            }
            if (o.getErrorState() == 1 || o.getWarningChildCount() > 0) {
                this.registerWarningChild();
            }
        }
        return b;
    }

    @Override
    public void removeChild_0(XModelObject o) {
        if (this.children.removeObject(o)) {
            if (o.getErrorState() == 2 || o.getErrorChildCount() > 0) {
                this.unregisterErrorChild();
            }
            if (o.getErrorState() == 1 || o.getWarningChildCount() > 0) {
                this.unregisterWarningChild();
            }
        }
    }

    @Override
    public void set(String name, String value) {
        if (!(this.getParent() instanceof RegularObjectImpl)) {
            super.set(name, value);
            return;
        }
        String ov = super.get(name);
        String opp = this.getPathPart();
        super.set(name, value);
        String npp = this.getPathPart();
        if (opp != null && opp.equals(npp)) {
            return;
        }
        RegularObjectImpl p = (RegularObjectImpl)this.getParent();
        XModelObject c = p.children.change(this, opp, npp);
        if (c != null) {
            if (this.getModelEntity().getAttribute(XModelObjectLoaderUtil.ATTR_ID_NAME) != null) {
                int k = 1;
                while (c != null) {
                    super.set(XModelObjectLoaderUtil.ATTR_ID_NAME, "" + k);
                    npp = this.getPathPart();
                    c = p.children.change(this, opp, npp);
                    ++k;
                }
                return;
            }
            if (this.hasIdAttr()) {
                int k = 1;
                while (c != null) {
                    super.set("__duplicate", "" + k);
                    npp = this.getPathPart();
                    if (k == 1 && npp.indexOf("__duplicate") < 0) {
                        this.elementExists(c, name, value);
                        return;
                    }
                    c = p.children.change(this, opp, npp);
                    ++k;
                }
            } else {
                if (ov == null) {
                    this.properties.remove(name);
                } else {
                    super.set(name, ov);
                }
                this.elementExists(c, name, value);
            }
        }
    }

    @Override
    public XModelObject getChildByPathPart(String pathpart) {
        this.loadChildren();
        return this.children.getObject(pathpart);
    }

    protected void elementExists(XModelObject o, String name, String value) {
        if (this.getModel().getService() == null) {
            return;
        }
        String mes = MessageFormat.format("Cannot set {0} = {1} for {2}\nbecause {3} exists in the {4}", this.getAttrNameByXMLName(name), value, RegularObjectImpl.title(this), RegularObjectImpl.title(o), RegularObjectImpl.title(this.getParent()));
        if (Display.getCurrent() != null) {
            this.getModel().getService().showDialog("Error", mes, new String[]{"OK"}, null, 1);
        }
        ModelPlugin.getDefault().logError(mes);
    }

    private static String title(XModelObject o) {
        return String.valueOf(o.getAttributeValue("element type")) + " " + o.getModelEntity().getRenderer().getTitle(o);
    }

    private String getAttrNameByXMLName(String name) {
        if (this.getModelEntity().getAttribute(name) != null) {
            return name;
        }
        XAttribute[] as = this.getModelEntity().getAttributes();
        int i = 0;
        while (i < as.length) {
            if (name.equals(as[i].getXMLName())) {
                return as[i].getName();
            }
            ++i;
        }
        return name;
    }

    @Override
    public int getIndexOfChild(XModelObject o) {
        return this.children.getIndex(o);
    }

    @Override
    public boolean move(int from, int to, boolean firechange) {
        boolean b = this.children.move(from, to);
        if (b) {
            this.fireStructureChanged(3, this);
            if (firechange) {
                this.setModified(true);
            }
        }
        return b;
    }

    public void replaceChildren(XModelObject[] objects) {
        int i = 0;
        while (i < objects.length) {
            ((XModelObjectImpl)objects[i]).setParent_0(this);
            ++i;
        }
        this.children.replaceChildren(objects);
        this.changeTimeStamp();
    }
}

