/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.views.properties.IPropertySource;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XMapping;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.adapter.IModelObjectAdapter;
import org.jboss.tools.common.model.adapter.ModelObjectAdapterExtensionPoint;
import org.jboss.tools.common.model.icons.impl.XModelObjectIcon;
import org.jboss.tools.common.model.impl.SProperties;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

public class XModelObjectImpl
implements XModelObject,
Serializable,
Cloneable {
    private static final long serialVersionUID = 3860648580262144825L;
    public static final String DUPLICATE = "__duplicate";
    private XModel model = null;
    private XModelEntity entity = null;
    private XModelObjectImpl parent = null;
    protected SP properties = new SProperties();
    protected boolean modified = false;
    protected long timeStamp = System.currentTimeMillis();
    protected long lastModificationTimeStamp = 0L;
    private Boolean hasIdAttr = null;
    Map<String, Object> context = null;
    static ModelObjectAdapterExtensionPoint ep = ModelObjectAdapterExtensionPoint.getInstance();
    private static IModelObjectAdapter propertySource = ep.getAdapter("IPropertySource");
    protected int errorState = 0;
    protected int errorChildCount = 0;
    protected int warningChildCount = 0;
    protected HashSet<String> errorAttributes;
    protected HashSet<String> errorAttributesDirty;

    @Override
    public XModel getModel() {
        return this.model;
    }

    void setModel(XModel model) {
        this.model = model;
    }

    @Override
    public XModelEntity getModelEntity() {
        return this.entity;
    }

    public void destroy() {
        this.parent = null;
    }

    public void changeEntity(String name) {
        String v;
        String n;
        if (this.entity.getName().equals(name)) {
            return;
        }
        XModelEntity newEntity = this.entity.getMetaModel().getEntity(name);
        if (newEntity == null) {
            throw new IllegalArgumentException("Entity " + name + " does not exist.");
        }
        if (this.entity.getImplementingClass() != newEntity.getImplementingClass()) {
            throw new IllegalArgumentException("Cannot convert entity " + this.entity.getName() + " to " + name + " because they have different implementations.");
        }
        Properties p = new Properties();
        XAttribute[] as = this.entity.getAttributes();
        int i = 0;
        while (i < as.length) {
            n = as[i].getName();
            v = this.getAttributeValue(n);
            if (v != null) {
                p.setProperty(n, v);
            }
            ++i;
        }
        this.entity = newEntity;
        as = newEntity.getAttributes();
        i = 0;
        while (i < as.length) {
            n = as[i].getName();
            v = p.getProperty(n);
            if (v == null) {
                v = as[i].getDefaultValue();
            }
            if (v == null) {
                v = "";
            }
            this.setAttributeValue(n, v);
            ++i;
        }
    }

    void setEntityName_0(String entityname) {
        this.entity = this.getModel().getMetaData().getEntity(entityname);
        ((SProperties)this.properties).init(this.entity);
        this.onSetEntity(entityname);
    }

    protected void onSetEntity(String entity) {
    }

    @Override
    public XModelObject getParent() {
        return this.parent;
    }

    public void setParent_0(XModelObjectImpl parent) {
        this.parent = parent;
        if (parent != null) {
            if (this.model != parent.getModel()) {
                this.setModel(parent.getModel());
            }
        } else {
            this.modified = false;
        }
    }

    @Override
    public boolean isActive() {
        return this.getParent() != null && this.getParent().isActive();
    }

    @Override
    public boolean isObjectEditable() {
        return this.getParent() == null || this.getParent().isObjectEditable();
    }

    @Override
    public boolean isAttributeEditable(String name) {
        return this.isObjectEditable();
    }

    @Override
    public int getFileType() {
        return 0;
    }

    @Override
    public String get(String name) {
        return this.properties.get(name);
    }

    @Override
    public void set(String name, String value) {
        if (value != null && value.length() < 100) {
            value = value.intern();
        }
        this.properties.put(name.intern(), value);
    }

    public boolean hasIdAttr() {
        if (this.hasIdAttr != null) {
            return this.hasIdAttr;
        }
        this.hasIdAttr = Boolean.FALSE;
        int i = 0;
        while (i < this.getModelEntity().getAttributes().length) {
            if ("true".equals(this.getModelEntity().getAttributes()[i].getProperty("id"))) {
                this.hasIdAttr = Boolean.TRUE;
                break;
            }
            ++i;
        }
        return this.hasIdAttr;
    }

    protected String get_0(String name) {
        XAttribute a = this.getModelEntity().getAttribute(name);
        return a == null || a.getAdapter() == null ? null : a.getAdapter().getProperty(this);
    }

    protected void set_0(String name, String value) {
        XAttribute a = this.getModelEntity().getAttribute(name);
        if (a != null && a.getAdapter() != null) {
            a.getAdapter().setProperty(this, value);
        }
    }

    @Override
    public Object getObject(String name) {
        return this.context == null ? null : this.context.get(name);
    }

    @Override
    public void setObject(String name, Object o) {
        if (this.context == null) {
            if (o == null) {
                return;
            }
            this.context = new HashMap<String, Object>();
        }
        if (o == null) {
            this.context.remove(name);
        } else {
            this.context.put(name, o);
        }
    }

    @Override
    public String getAttributeValue(String name) {
        return this.get_0(name);
    }

    @Override
    public String setAttributeValue(String name, String value) {
        if (this.getModelEntity().getAttribute(name) == null) {
            return "";
        }
        String ov = this.getAttributeValue(name);
        if (value != null && value.equals(ov)) {
            return ov;
        }
        String path = this.getPath();
        this.set_0(name, value);
        String nv = this.getAttributeValue(name);
        if (nv != null && !nv.equals(ov)) {
            this.changeTimeStamp();
            if (path != null) {
                ((XModelImpl)this.getModel()).fireNodeChanged(this, path);
            }
        }
        return nv;
    }

    protected void onAttributeValueEdit(String name, String oldValue, String newValue) throws XModelException {
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void setModified(boolean value) {
        if (this.parent != null && value) {
            this.parent.setModified(value);
        }
        this.modified = value;
        if (this.modified) {
            ++this.lastModificationTimeStamp;
        }
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public long getLastModificationTimeStamp() {
        return this.lastModificationTimeStamp;
    }

    protected void changeTimeStamp() {
        ++this.timeStamp;
        if (this.parent != null) {
            this.parent.changeTimeStamp();
        }
    }

    protected void safeChangeTimeStamp() {
        ++this.timeStamp;
        if (this.parent != null) {
            this.parent.safeChangeTimeStamp();
        }
    }

    @Override
    public XModelObject[] getChildren() {
        return new XModelObject[0];
    }

    @Override
    public XModelObject[] getChildren(String name) {
        XModelObject[] mes = this.getChildren();
        ArrayList<XModelObject> v = new ArrayList<XModelObject>();
        int i = 0;
        while (i < mes.length) {
            if (name.equals(mes[i].getModelEntity().getName())) {
                v.add(mes[i]);
            }
            ++i;
        }
        return v.toArray(new XModelObject[v.size()]);
    }

    @Override
    public XModelObject[] getChildrenForSave() {
        return this.getChildren();
    }

    public XModelObject[] getLoadedChildren() {
        return this.getChildren();
    }

    @Override
    public XModelObject getChildAt(int i) {
        XModelObject[] children = this.getChildren();
        return i < 0 || i >= children.length ? null : children[i];
    }

    @Override
    public boolean hasChildren() {
        return this.getChildren().length > 0;
    }

    @Override
    public boolean addChild(XModelObject object) {
        boolean b = this.addChild_0(object);
        if (b) {
            this.fireStructureChanged(1, object);
        }
        return b;
    }

    public boolean addChild_0(XModelObject o) {
        return false;
    }

    @Override
    public void removeChild(XModelObject child) {
        if (child.getParent() != this) {
            return;
        }
        String path = child.getPath();
        this.removeChild_0(child);
        this.fireStructureChanged(2, path);
    }

    public void removeChild_0(XModelObject o) {
    }

    @Override
    public void removeFromParent() {
        if (this.getParent() != null) {
            this.getParent().removeChild(this);
        }
    }

    public String getLongPath() {
        if (this.getParent() == null) {
            return null;
        }
        String p = this.parent.getLongPath();
        return p == null ? null : (p.length() == 0 ? this.getPathPart() : String.valueOf(p) + "/" + this.getPathPart());
    }

    @Override
    public String getPath() {
        int ib;
        String lp = this.getLongPath();
        if (lp == null) {
            return null;
        }
        XMapping m = this.getModel().getMetaData().getMapping("Roots");
        String h = lp;
        do {
            String q;
            String r;
            if ((r = m.getValue(q = h.substring((ib = h.lastIndexOf(47)) + 1))) == null || !h.equals(r)) continue;
            return "%" + q + "%" + lp.substring(r.length());
        } while ((h = ib >= 0 ? h.substring(0, ib) : null) != null);
        return lp;
    }

    @Override
    public String getPathPart() {
        String p = this.name();
        p = p == null || p.indexOf(47) < 0 ? p : p.replace('/', '#');
        return this.applyDuplicate(p);
    }

    protected final String applyDuplicate(String pathpart) {
        String duplicate = this.get(DUPLICATE);
        return duplicate == null || duplicate.length() == 0 ? pathpart : String.valueOf(pathpart) + DUPLICATE + duplicate;
    }

    @Override
    public XModelObject getChildByPath(String path) {
        int i = path.indexOf("/");
        String n = i < 0 ? path : path.substring(0, i);
        String f = i < 0 ? "" : path.substring(i + 1);
        XModelObject me = this.getChildByPathPart(n);
        if (me == null) {
            if (n.equals("..")) {
                me = this.getParent();
            } else if (n.equals(".")) {
                me = this;
            }
        }
        return me == null || i < 0 ? me : me.getChildByPath(f);
    }

    public XModelObject getChildByPathPart(String pathpart) {
        XModelObject[] cs = this.getChildren();
        int i = 0;
        while (i < cs.length) {
            if (cs[i].getPathPart().equals(pathpart)) {
                return cs[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public XModelObject copy(boolean transform, int level) {
        XModelObject copy = this.shallow_copy(transform);
        if (copy != null) {
            copy.setModified(true);
        }
        if (level == 0 || copy == null) {
            return copy;
        }
        XModelObject[] cs = this.getChildrenForSave();
        int i = 0;
        while (i < cs.length) {
            XModelObject ccopy = cs[i].copy(transform, level - 1);
            if (ccopy != null) {
                copy.addChild(ccopy);
            }
            ++i;
        }
        return copy;
    }

    @Override
    public XModelObject copy(boolean transform) {
        if (this.getModel() == null) {
            return null;
        }
        XModelObject copy = this.shallow_copy(transform);
        if (copy != null) {
            this.copy_children(copy, transform);
        }
        return copy;
    }

    @Override
    public XModelObject copy(int level) {
        return this.copy(false, level);
    }

    public XModelObject shallow_copy(boolean transform) {
        String d;
        XAttribute[] as = this.getModelEntity().getAttributes();
        Properties p = new Properties();
        int i = 0;
        while (i < as.length) {
            String n;
            String v;
            if (as[i].isCopyable() && (v = this.getAttributeValue(n = as[i].getName())) != null) {
                p.setProperty(n, this.getAttributeValue(n));
            }
            ++i;
        }
        String entity = transform ? this.getEntityForCopy() : this.getModelEntity().getName();
        XModelObject c = this.getModel().createModelObject(entity, p);
        if (c != null) {
            c.setModified(true);
        }
        if ((d = this.get(DUPLICATE)) != null && d.length() > 0) {
            c.set(DUPLICATE, d);
        }
        return c;
    }

    protected void copy_children(XModelObject copy, boolean transform) {
        XModelObject[] cs = this.getChildrenForSave();
        int i = 0;
        while (i < cs.length) {
            XModelObjectImpl c = (XModelObjectImpl)cs[i];
            XModelObject ccopy = c.shallow_copy(transform);
            if (ccopy != null) {
                XModelObject cc;
                c.copy_children(ccopy, transform);
                if (!copy.addChild(ccopy) && (cc = copy.getChildByPath(ccopy.getPathPart())) != null) {
                    copy.removeChild(cc);
                    copy.addChild(ccopy);
                }
            }
            ++i;
        }
    }

    @Override
    public XModelObject copy() {
        return this.copy(true);
    }

    protected String getEntityForCopy() {
        return this.getModelEntity().getName();
    }

    @Override
    public String getPresentationString() {
        return this.name();
    }

    protected String name() {
        XAttribute a = this.getModelEntity().getAttribute("name");
        return a != null ? this.getAttributeValue("name") : this.getModelEntity().getName();
    }

    @Override
    public String getMainIconName() {
        try {
            return this.getModelEntity().getRenderer().getIconInfo("main");
        }
        catch (NullPointerException nullPointerException) {
            return "main.closedbox";
        }
    }

    @Override
    public Image getImage() {
        return new XModelObjectIcon(this).getEclipseImage();
    }

    @Override
    public Image getImage(String[] types) {
        return new XModelObjectIcon(this).getEclipseImage0(types);
    }

    protected void fireStructureChanged(int kind, Object info) {
        this.changeTimeStamp();
        XModelImpl m = (XModelImpl)this.getModel();
        m.fireStructureChanged(this, kind, info);
    }

    @Override
    public boolean isEqual(XModelObject o) {
        XModelObject[] cb;
        if (o == null) {
            return false;
        }
        if (!this.getModelEntity().getName().equals(o.getModelEntity().getName())) {
            return false;
        }
        XAttribute[] as = this.getModelEntity().getAttributes();
        int i = 0;
        while (i < as.length) {
            if (as[i].isCopyable()) {
                String n = as[i].getName();
                String va = this.getAttributeValue(n);
                String vb = o.getAttributeValue(n);
                if (va == null && vb != null || !va.equals(vb)) {
                    return false;
                }
            }
            ++i;
        }
        XModelObject[] ca = this.getChildrenForSave();
        if (ca.length != (cb = o.getChildrenForSave()).length) {
            return false;
        }
        int i2 = 0;
        while (i2 < ca.length) {
            if (!ca[i2].isEqual(cb[i2])) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public Object getAdapter(Class adapter) {
        if (XModelObject.class == adapter) {
            return this;
        }
        if (adapter == IResource.class) {
            return null;
        }
        if (adapter == IProject.class) {
            return EclipseResourceUtil.getProject(this);
        }
        if (adapter == IFile.class) {
            XModelObject f = this.getResourceAncestor();
            IResource o = f == null ? null : (IResource)f.getAdapter(IResource.class);
            return o instanceof IFile ? o : null;
        }
        if (adapter == IJavaElement.class) {
            return EclipseResourceUtil.findJavaElement(this);
        }
        if (adapter == IActionFilter.class) {
            IModelObjectAdapter af = ep.getAdapter("IActionFilter");
            if (af != null) {
                af.setModelObject(this);
            }
            return af;
        }
        if (adapter == IPropertySource.class) {
            if (propertySource != null) {
                propertySource.setModelObject(this);
            }
            return propertySource;
        }
        return null;
    }

    public XModelObject getResourceAncestor() {
        XModelObject p = this;
        while (p != null && p.getFileType() == 0) {
            p = p.getParent();
        }
        return p;
    }

    @Override
    public void fireObjectChanged(Object details) {
        ((XModelImpl)this.getModel()).fireNodeChanged(this, this.getPath(), details);
    }

    @Override
    public int getErrorState() {
        return this.errorState;
    }

    @Override
    public int getErrorChildCount() {
        return this.errorChildCount;
    }

    @Override
    public int getWarningChildCount() {
        return this.warningChildCount;
    }

    @Override
    public boolean getAttributeErrorState(String attributeName) {
        return this.errorAttributes != null && this.errorAttributes.contains(attributeName);
    }

    @Override
    public void setErrorState(int b) {
        if (b != 0) {
            this.commitErrorAttributes();
        }
        if (this.errorState == b) {
            return;
        }
        int oldErrorState = this.errorState;
        this.errorState = b;
        if (b == 0) {
            this.errorAttributes = null;
            this.errorAttributesDirty = null;
        }
        if (this.errorChildCount > 0 && b == 2 && oldErrorState == 0) {
            return;
        }
        if (this.warningChildCount > 0 && b == 1 && oldErrorState == 0) {
            return;
        }
        this.fireErrorStateChanged();
        if (this.parent != null) {
            if (oldErrorState == 2 && this.errorChildCount == 0) {
                this.parent.unregisterErrorChild();
            } else if (oldErrorState == 1 && this.warningChildCount == 0) {
                this.parent.unregisterWarningChild();
            }
            if (this.errorState == 2 && this.errorChildCount == 0) {
                this.parent.registerErrorChild();
            } else if (this.errorState == 1 && this.warningChildCount == 0) {
                this.parent.registerWarningChild();
            }
        }
    }

    public void registerErrorChild() {
        ++this.errorChildCount;
        if (this.errorChildCount == 1 && this.errorState != 2) {
            this.fireErrorStateChanged();
            if (this.parent != null) {
                this.parent.registerErrorChild();
            }
        }
    }

    public void unregisterErrorChild() {
        --this.errorChildCount;
        if (this.errorChildCount == 0 && this.errorState != 2) {
            this.fireErrorStateChanged();
            if (this.parent != null) {
                this.parent.unregisterErrorChild();
            }
        }
    }

    public void registerWarningChild() {
        ++this.warningChildCount;
        if (this.warningChildCount == 1 && this.errorState != 1) {
            this.fireErrorStateChanged();
            if (this.parent != null) {
                this.parent.registerWarningChild();
            }
        }
    }

    public void unregisterWarningChild() {
        --this.warningChildCount;
        if (this.warningChildCount == 0 && this.errorState != 1) {
            this.fireErrorStateChanged();
            if (this.parent != null) {
                this.parent.unregisterWarningChild();
            }
        }
    }

    private void fireErrorStateChanged() {
        this.safeChangeTimeStamp();
        String path = this.getPath();
        if (path != null) {
            this.fireObjectChanged(null);
        }
    }

    public void addErrorAttributeDirty(String attributeName) {
        if (this.errorAttributesDirty == null) {
            this.errorAttributesDirty = new HashSet();
        }
        this.errorAttributesDirty.add(attributeName);
    }

    public void commitErrorAttributes() {
        if (this.errorAttributes == null) {
            if (this.errorAttributesDirty == null) {
                return;
            }
            this.errorAttributes = this.errorAttributesDirty;
            this.errorAttributesDirty = null;
            this.fireErrorStateChanged();
        } else if (this.errorAttributesDirty == null) {
            this.errorAttributes = null;
            this.fireErrorStateChanged();
        } else {
            boolean b = false;
            Iterator<String> it = this.errorAttributes.iterator();
            while (it.hasNext()) {
                String o = it.next();
                if (this.errorAttributesDirty.contains(o)) continue;
                b = true;
                it.remove();
            }
            for (String o : this.errorAttributesDirty) {
                if (this.errorAttributes.contains(o)) continue;
                b = true;
                this.errorAttributes.add(o);
            }
            if (this.errorAttributes.isEmpty()) {
                this.errorAttributes = null;
            }
            this.errorAttributesDirty = null;
            if (b) {
                this.fireErrorStateChanged();
            }
        }
    }

    public static interface SP {
        public String get(String var1);

        public void put(String var1, String var2);

        public void remove(String var1);
    }
}

