/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.plugin;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.runtime.CoreException;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;

public class XModelSaveParticipant
implements ISaveParticipant {
    ArrayList<XModel> models = new ArrayList();
    ArrayList<XModel> toSave = new ArrayList();

    public void addModel(XModel model) {
        if (!this.models.contains(model)) {
            this.models.add(model);
        }
    }

    public void removeModel(XModel model) {
        int i = this.models.indexOf(model);
        if (i >= 0) {
            this.models.remove(i);
        }
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    private void check() {
        this.toSave.clear();
        XModelObject[] modified = this.getModified();
        if (modified.length == 0) {
            return;
        }
        int i = 0;
        while (i < modified.length) {
            this.toSave.add(modified[i].getModel());
            ++i;
        }
    }

    public void saving(ISaveContext context) throws CoreException {
        this.check();
        XModel[] ms = this.toSave.toArray(new XModel[0]);
        int i = 0;
        while (i < ms.length) {
            ms[i].save();
            ++i;
        }
    }

    public void rollback(ISaveContext context) {
    }

    public void doneSaving(ISaveContext context) {
        this.toSave.clear();
    }

    private XModelObject[] getModified() {
        XModel[] ms = this.models.toArray(new XModel[0]);
        ArrayList<XModelObject> l = new ArrayList<XModelObject>();
        int i = 0;
        while (i < ms.length) {
            XModelObject fs;
            IProject p = (IProject)ms[i].getProperties().get("project");
            if (p != null && p.isOpen() && ms[i].getRoot().isModified() && (fs = FileSystemsHelper.getFileSystems(ms[i])) != null) {
                l.add(fs);
            }
            ++i;
        }
        return l.toArray(new XModelObject[0]);
    }
}

