/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.undo;

import java.util.ArrayList;
import org.jboss.tools.common.model.undo.XUndoable;
import org.jboss.tools.common.model.undo.XUndoableImpl;

public class XTransactionUndo
extends XUndoableImpl {
    protected boolean progress = true;
    protected ArrayList<XUndoable> components = new ArrayList();

    public XTransactionUndo(String description, int kind) {
        this.description = description;
        this.kind = kind < 0 || kind > 2 ? 1 : kind;
    }

    @Override
    protected void doUndo() {
        this.commit();
        int i = this.components.size() - 1;
        while (i >= 0) {
            XUndoable u = this.components.get(i);
            if (u.canUndo()) {
                u.undo();
            }
            --i;
        }
    }

    @Override
    protected void doRedo() {
        this.commit();
        int i = 0;
        while (i < this.components.size()) {
            XUndoable u = this.components.get(i);
            if (u.canRedo()) {
                u.redo();
            }
            ++i;
        }
    }

    @Override
    protected boolean merge(XUndoableImpl u) {
        if (!this.isInProgress()) {
            return false;
        }
        this.components.add(u);
        return true;
    }

    public void commit() {
        this.progress = false;
    }

    boolean isInProgress() {
        return this.progress;
    }
}

