/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.resref.core;

import org.jboss.tools.common.resref.core.Messages;

public class ResourceReference {
    public static final int FILE_SCOPE = 0;
    public static final int FOLDER_SCOPE = 1;
    public static final int PROJECT_SCOPE = 2;
    public static final int GLOBAL_SCOPE = 3;
    public static final String[] SCOPE_NAMES = new String[]{"Page", "Folder", "Project", "Global"};
    private static final String[] LOCALIZED_SCOPE_NAMES = new String[]{Messages.ResourceReference_Page, Messages.ResourceReference_Folder, Messages.ResourceReference_Project, Messages.ResourceReference_Global};
    protected String location;
    protected int scope;
    protected int depth = 0;
    protected String properties = "";
    protected boolean isGlobal = false;

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public void setGlobal(boolean isGlobal) {
        this.isGlobal = isGlobal;
    }

    public ResourceReference(String location, int scope) {
        this.location = location;
        this.scope = scope;
        int q = location.indexOf(37);
        if (q >= 0) {
            this.properties = location.substring(q + 1);
            this.location = location.substring(0, q);
        }
    }

    public String getLocation() {
        return this.location;
    }

    public int getScope() {
        return this.scope;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public String getProperties() {
        return this.properties;
    }

    public void setScope(int scope) {
        this.scope = scope;
    }

    public String getScopeName() {
        return SCOPE_NAMES[this.scope];
    }

    public String getLocalizedScopeName() {
        return LOCALIZED_SCOPE_NAMES[this.scope];
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public String getLocationAndProperties() {
        String v = this.location;
        if (this.properties.length() > 0) {
            v = String.valueOf(v) + "%" + this.properties;
        }
        return v;
    }
}

