/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink;

import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.common.text.ext.hyperlink.xpl.HierarchyInformationControl;
import org.jboss.tools.common.text.ext.hyperlink.xpl.InformationPresenter;

public class InformationControlManager {
    public static final InformationControlManager instance = new InformationControlManager();

    public IInformationControl showHyperlinks(String title, ITextViewer viewer, IHyperlink[] hyperlinks) {
        return this.showHyperlinks(title, viewer, hyperlinks, false);
    }

    public IInformationControl showHyperlinks(String title, ITextViewer viewer, IHyperlink[] hyperlinks, boolean test) {
        InformationPresenter presenter = new InformationPresenter(viewer, this.getHierarchyPresenterControlCreator(title, hyperlinks));
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        presenter.setSizeConstraints(60, 10, true, false);
        presenter.install((Control)viewer.getTextWidget());
        if (test) {
            return presenter.showInformationForTest();
        }
        presenter.showInformation();
        return null;
    }

    protected IInformationControlCreator getHierarchyPresenterControlCreator(final String title, final IHyperlink[] hyperlinks) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                HierarchyInformationControl iControl = new HierarchyInformationControl(parent, title, shellStyle, treeStyle, hyperlinks);
                iControl.setInput(hyperlinks);
                return iControl;
            }
        };
    }
}

