/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink.xpl;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.util.PathHelper;
import org.eclipse.wst.sse.core.internal.util.URIResolver;
import org.eclipse.wst.sse.ui.internal.openon.ExternalFileEditorInput;
import org.eclipse.wst.sse.ui.internal.util.PlatformStatusLineUtil;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;

public abstract class AbstractBaseHyperlink {
    protected final String FILE_PROTOCOL = "file:/";
    public final String HTTP_PROTOCOL = "http://";
    protected IRegion hyperlinkRegion;
    private IDocument fDocument;
    private int fOffset;

    public void setRegion(IRegion region) {
        this.hyperlinkRegion = region;
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
    }

    public void setOffset(int offset) {
        this.fOffset = offset;
    }

    public int getOffset() {
        return this.fOffset;
    }

    protected void openFileInEditor(String fileString) {
        IEditorPart editor = null;
        if (fileString != null) {
            IFile file;
            String temp = fileString.toLowerCase();
            if (temp.startsWith("http://")) {
                return;
            }
            if (temp.startsWith("file:/")) {
                fileString = fileString.substring("file:/".length());
            }
            editor = (file = this.getFile(fileString)) != null ? AbstractBaseHyperlink.openFileInEditor(file) : this.openExternalFile(fileString);
        }
        if (editor == null) {
            this.openFileFailed();
        }
    }

    protected IFile getFile(String fileString) {
        if (fileString != null) {
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(fileString));
            int i = 0;
            while (i < files.length) {
                if (files[i].exists()) {
                    return files[i];
                }
                ++i;
            }
        }
        return null;
    }

    public static IEditorPart openFileInEditor(IFile input) {
        if (input != null && input.exists()) {
            try {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                return IDE.openEditor((IWorkbenchPage)page, (IFile)input, (boolean)true);
            }
            catch (PartInitException pie) {
                ResourcesPlugin.getPlugin().getLog().log(AbstractBaseHyperlink.createStatus((Exception)((Object)pie)));
            }
        }
        return null;
    }

    private static IStatus createStatus(Exception ex) {
        return new Status(4, "org.jboss.tools.common.text.ext", 0, String.valueOf(ex.getMessage()), (Throwable)ex);
    }

    protected IEditorPart openFileInEditor(IEditorInput input, String fileString) {
        if (input != null && input.exists()) {
            try {
                String editorId = this.getEditorId(fileString);
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                return IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)editorId, (boolean)true);
            }
            catch (PartInitException pie) {
                ResourcesPlugin.getPlugin().getLog().log(AbstractBaseHyperlink.createStatus((Exception)((Object)pie)));
            }
        }
        return null;
    }

    protected IEditorPart openExternalFile(String fileString) {
        File file = new File(fileString);
        if (!file.exists()) {
            return null;
        }
        ExternalFileEditorInput input = new ExternalFileEditorInput(file);
        String editorId = this.getEditorId(fileString);
        try {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            return page.openEditor((IEditorInput)input, editorId, true);
        }
        catch (PartInitException pie) {
            ResourcesPlugin.getPlugin().getLog().log(AbstractBaseHyperlink.createStatus((Exception)((Object)pie)));
            return null;
        }
    }

    protected String getEditorId(String filename) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(filename);
        if (descriptor != null) {
            return descriptor.getId();
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }

    protected void openFileFailed() {
        PlatformStatusLineUtil.displayErrorMessage((String)Messages.cannotOpenLink);
        PlatformStatusLineUtil.addOneTimeClearListener();
    }

    protected String resolveURI(String uriString) {
        String resolvedURI = uriString;
        if (uriString != null) {
            IStructuredModel sModel = null;
            try {
                sModel = this.getModelManager().getExistingModelForRead(this.getDocument());
                if (sModel != null) {
                    URIResolver resolver = sModel.getResolver();
                    resolvedURI = resolver != null ? resolver.getLocationByURI(uriString, true) : uriString;
                }
            }
            finally {
                if (sModel != null) {
                    sModel.releaseFromRead();
                }
            }
            if (uriString.startsWith("file:/")) {
                PathHelper.removeLeadingSeparator((String)resolvedURI);
            }
        }
        return resolvedURI;
    }

    protected IModelManager getModelManager() {
        return StructuredModelManager.getModelManager();
    }

    public IRegion getHyperlinkRegion() {
        if (this.hyperlinkRegion != null) {
            return this.hyperlinkRegion;
        }
        this.hyperlinkRegion = (IHyperlinkRegion)this.doGetHyperlinkRegion(this.getOffset());
        return this.hyperlinkRegion != null ? this.hyperlinkRegion : new Region(this.getOffset(), 0);
    }

    protected abstract IRegion doGetHyperlinkRegion(int var1);

    public void open() {
        IRegion region = this.getHyperlinkRegion();
        if (this.getDocument() == null || region == null) {
            this.openFileFailed();
        } else {
            this.doHyperlink(region);
        }
    }

    protected abstract void doHyperlink(IRegion var1);

    public IDocument getDocument() {
        return this.fDocument;
    }

    public abstract String getHyperlinkText();

    public String getTypeLabel() {
        return null;
    }
}

