/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink.xpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.swt.custom.BusyIndicator;
import org.jboss.tools.common.text.ext.ExtensionsPlugin;
import org.osgi.framework.Bundle;

public class HyperlinkDefinition {
    private String fId = null;
    private String fClassName = null;
    private HashMap fContentTypes = null;
    private IConfigurationElement fConfigurationElement = null;

    public HyperlinkDefinition(String id, String class1, IConfigurationElement configurationElement) {
        this.fId = id;
        this.fClassName = class1;
        this.fConfigurationElement = configurationElement;
        this.fContentTypes = new HashMap();
    }

    public void addContentTypeId(String contentTypeId) {
        if (!this.fContentTypes.containsKey(contentTypeId)) {
            this.fContentTypes.put(contentTypeId, new ArrayList());
        }
    }

    public void addPartitionType(String contentTypeId, String partitionType) {
        if (!this.fContentTypes.containsKey(contentTypeId)) {
            this.fContentTypes.put(contentTypeId, new ArrayList());
        }
        List partitionList = (List)this.fContentTypes.get(contentTypeId);
        partitionList.add(partitionType);
    }

    public String getClassName() {
        return this.fClassName;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.fConfigurationElement;
    }

    public HashMap getContentTypes() {
        return this.fContentTypes;
    }

    public String getId() {
        return this.fId;
    }

    public IHyperlink createHyperlink() {
        IHyperlink hyperlink = null;
        if (this.getClassName() != null) {
            hyperlink = (IHyperlink)this.createExtension("class");
        }
        return hyperlink;
    }

    private Object createExtension(String propertyName) {
        final IConfigurationElement element = this.getConfigurationElement();
        final String name = propertyName;
        final Object[] result = new Object[1];
        Bundle bundle = Platform.getBundle((String)element.getDeclaringExtension().getNamespaceIdentifier());
        if (bundle.getState() == 32) {
            try {
                return element.createExecutableExtension(name);
            }
            catch (CoreException e) {
                this.handleCreateExecutableException(result, (Exception)((Object)e));
            }
        } else {
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        result[0] = element.createExecutableExtension(name);
                    }
                    catch (CoreException e) {
                        HyperlinkDefinition.this.handleCreateExecutableException(result, (Exception)((Object)e));
                    }
                }
            });
        }
        return result[0];
    }

    private void handleCreateExecutableException(Object[] result, Exception x) {
        ExtensionsPlugin.getPluginLog().logError("Error in creating extension", (Throwable)x);
        result[0] = null;
    }
}

