/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.validation.java;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.common.validation.CommonValidationPlugin;
import org.jboss.tools.common.validation.java.JavaDirtyRegionProcessor;

public class JavaEditorTracker
implements IWindowListener,
IPageListener,
IPartListener {
    static JavaEditorTracker INSTANCE;
    Map<JavaEditor, JavaDirtyRegionProcessor> fAsYouTypeValidators = new HashMap<JavaEditor, JavaDirtyRegionProcessor>();

    private JavaEditorTracker() {
        this.init();
    }

    public static JavaEditorTracker getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JavaEditorTracker();
        }
        return INSTANCE;
    }

    private void init() {
        IWorkbench workbench;
        if (PlatformUI.isWorkbenchRunning() && (workbench = CommonValidationPlugin.getDefault().getWorkbench()) != null) {
            IWorkbenchWindow[] windows;
            IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                this.windowOpened(window);
                ++n2;
            }
            CommonValidationPlugin.getDefault().getWorkbench().addWindowListener((IWindowListener)this);
        }
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        IWorkbenchPage[] pages;
        IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            this.pageClosed(page);
            ++n2;
        }
        window.removePageListener((IPageListener)this);
    }

    public void windowOpened(IWorkbenchWindow window) {
        if (window.getShell() != null) {
            IWorkbenchPage[] pages;
            IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchPage page = iWorkbenchPageArray[n2];
                this.pageOpened(page);
                ++n2;
            }
            window.addPageListener((IPageListener)this);
        }
    }

    public void pageActivated(IWorkbenchPage page) {
    }

    public void pageClosed(IWorkbenchPage page) {
        IEditorReference[] rs;
        IEditorReference[] iEditorReferenceArray = rs = page.getEditorReferences();
        int n = rs.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference r = iEditorReferenceArray[n2];
            IEditorPart part = r.getEditor(false);
            if (part != null) {
                this.editorClosed(part);
            }
            ++n2;
        }
        page.removePartListener((IPartListener)this);
    }

    public void pageOpened(IWorkbenchPage page) {
        IEditorReference[] rs;
        IEditorReference[] iEditorReferenceArray = rs = page.getEditorReferences();
        int n = rs.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference r = iEditorReferenceArray[n2];
            IEditorPart part = r.getEditor(false);
            if (part != null) {
                this.editorOpened(part);
            }
            ++n2;
        }
        page.addPartListener((IPartListener)this);
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            this.editorClosed((IEditorPart)part);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            this.editorOpened((IEditorPart)part);
        }
    }

    private void editorOpened(IEditorPart part) {
        if (part instanceof JavaEditor) {
            JavaEditor javaEditor = (JavaEditor)part;
            JavaSourceViewer javaSourceViewer = (JavaSourceViewer)javaEditor.getViewer();
            JavaDirtyRegionProcessor processor = this.fAsYouTypeValidators.get(javaEditor);
            if (processor != null) {
                this.editorClosed(part);
                Assert.isTrue((this.fAsYouTypeValidators.get(javaEditor) == null ? 1 : 0) != 0, (String)"An old JavaDirtyRegionProcessor is not un-installed on Java Editor instance");
            }
            processor = new JavaDirtyRegionProcessor((ITextEditor)javaEditor);
            processor.install((ITextViewer)javaSourceViewer);
            processor.setDocument(javaSourceViewer.getDocument());
            processor.setDocumentPartitioning("___java_partitioning");
            processor.startReconciling();
            this.fAsYouTypeValidators.put(javaEditor, processor);
        }
    }

    private void editorClosed(IEditorPart part) {
        JavaEditor javaEditor;
        JavaDirtyRegionProcessor processor;
        if (part instanceof JavaEditor && (processor = this.fAsYouTypeValidators.remove(javaEditor = (JavaEditor)part)) != null) {
            processor.uninstall();
            Assert.isTrue((this.fAsYouTypeValidators.get(javaEditor) == null ? 1 : 0) != 0, (String)"An old JavaDirtyRegionProcessor is not un-installed on Java Editor instance");
        }
    }
}

