/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.quickfix;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;
import org.jboss.tools.common.CommonPlugin;
import org.jboss.tools.common.quickfix.IQuickFixGenerator;
import org.jboss.tools.common.refactoring.MarkerResolutionUtils;

public abstract class AbstractQuickFixGenerator
implements IMarkerResolutionGenerator2,
IQuickFixGenerator {
    protected static final String JAVA_EXTENSION = "java";
    protected static final String XML_EXTENSION = "xml";
    protected static final int MARKER_RESULUTION_NUMBER_LIMIT = 7;
    public static final String MESSAGE_ID_ATTRIBUTE_NAME = "Message_id";

    protected abstract IMarkerResolution[] findResolutions(IMarker var1) throws CoreException;

    public IMarkerResolution[] getResolutions(IMarker marker) {
        try {
            return this.findResolutions(marker);
        }
        catch (CoreException ex) {
            CommonPlugin.getDefault().logError(ex);
            return new IMarkerResolution[0];
        }
    }

    public boolean hasResolutions(IMarker marker) {
        if (marker.exists()) {
            try {
                return this.getMessageID(marker) >= 0;
            }
            catch (CoreException ex) {
                CommonPlugin.getDefault().logError(ex);
            }
        }
        return false;
    }

    protected int getMessageID(TemporaryAnnotation annotation) {
        Integer attribute;
        if (annotation.getAttributes() != null && (attribute = (Integer)annotation.getAttributes().get(MESSAGE_ID_ATTRIBUTE_NAME)) != null) {
            return attribute;
        }
        return -1;
    }

    protected int getMessageID(IMarker marker) throws CoreException {
        Integer attribute = (Integer)marker.getAttribute(MESSAGE_ID_ATTRIBUTE_NAME);
        if (attribute != null) {
            return attribute;
        }
        return -1;
    }

    protected IJavaElement findJavaElementByQualifiedName(IJavaProject javaProject, String qualifiedName) {
        try {
            return javaProject.findType(qualifiedName);
        }
        catch (JavaModelException ex) {
            CommonPlugin.getDefault().logError(ex);
            return null;
        }
    }

    protected IMethod findMethod(ICompilationUnit compilationUnit, int start) {
        IMethod method;
        IJavaElement javaElement = this.findJavaElement(compilationUnit, start);
        if (javaElement instanceof IMethod && !(method = (IMethod)javaElement).isBinary()) {
            return method;
        }
        return null;
    }

    protected IJavaElement findJavaElement(ICompilationUnit compilationUnit, int start) {
        try {
            return compilationUnit == null ? null : compilationUnit.getElementAt(start);
        }
        catch (JavaModelException ex) {
            CommonPlugin.getDefault().logError(ex);
            return null;
        }
    }

    protected ILocalVariable findParameter(ICompilationUnit compilationUnit, int start) {
        IJavaElement element = this.findJavaElement(compilationUnit, start);
        if (element instanceof IMethod) {
            try {
                ILocalVariable[] iLocalVariableArray = ((IMethod)element).getParameters();
                int n = iLocalVariableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ILocalVariable parameter = iLocalVariableArray[n2];
                    if (parameter.getSourceRange().getOffset() <= start && parameter.getSourceRange().getOffset() + parameter.getSourceRange().getLength() > start) {
                        return parameter;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException ex) {
                CommonPlugin.getDefault().logError(ex);
            }
        }
        return null;
    }

    protected boolean isMethodExists(IType interfaceType, IMethod method) {
        IMethod existingMethod = interfaceType.getMethod(method.getElementName(), method.getParameterTypes());
        return existingMethod.exists();
    }

    protected IField findNonStaticField(ICompilationUnit compilationUnit, int start) {
        try {
            IField field;
            IJavaElement javaElement = this.findJavaElement(compilationUnit, start);
            if (javaElement instanceof IField && !Flags.isStatic((int)(field = (IField)javaElement).getFlags()) && !field.isBinary()) {
                return field;
            }
        }
        catch (JavaModelException ex) {
            CommonPlugin.getDefault().logError(ex);
        }
        return null;
    }

    protected IField findPublicField(ICompilationUnit compilationUnit, int start) {
        try {
            IField field;
            IJavaElement javaElement = this.findJavaElement(compilationUnit, start);
            if (javaElement instanceof IField && Flags.isPublic((int)(field = (IField)javaElement).getFlags()) && !field.isBinary()) {
                return field;
            }
        }
        catch (JavaModelException ex) {
            CommonPlugin.getDefault().logError(ex);
        }
        return null;
    }

    protected IAnnotation getAnnotation(IJavaElement element, String annotationQualifiedName) {
        if (element instanceof IAnnotatable) {
            String shortName = MarkerResolutionUtils.getShortName(annotationQualifiedName);
            try {
                IAnnotation[] annotations;
                IAnnotation[] iAnnotationArray = annotations = ((IAnnotatable)element).getAnnotations();
                int n = annotations.length;
                int n2 = 0;
                while (n2 < n) {
                    IAnnotation annotation = iAnnotationArray[n2];
                    if (annotation.getElementName().equals(annotationQualifiedName) || annotation.getElementName().equals(shortName)) {
                        return annotation;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                CommonPlugin.getDefault().logError(e);
            }
        }
        return null;
    }

    protected IJavaElement findJavaElementByAnnotation(IJavaElement element, String qualifiedName) throws JavaModelException {
        IAnnotation annotation = this.getAnnotation(element, qualifiedName);
        if (annotation != null) {
            return element;
        }
        if (element instanceof IMethod) {
            ILocalVariable[] iLocalVariableArray = ((IMethod)element).getParameters();
            int n = iLocalVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILocalVariable parameter = iLocalVariableArray[n2];
                annotation = this.getAnnotation((IJavaElement)parameter, qualifiedName);
                if (annotation != null) {
                    return parameter;
                }
                ++n2;
            }
        } else if (element instanceof ILocalVariable) {
            IJavaElement parent = element.getParent();
            if (parent != null && (annotation = this.getAnnotation(parent, qualifiedName)) != null) {
                return parent;
            }
        } else if (element instanceof IType) {
            IField[] iFieldArray = ((IType)element).getFields();
            int n = iFieldArray.length;
            int n3 = 0;
            while (n3 < n) {
                IField field = iFieldArray[n3];
                annotation = this.getAnnotation((IJavaElement)field, qualifiedName);
                if (annotation != null) {
                    return field;
                }
                ++n3;
            }
            iFieldArray = ((IType)element).getMethods();
            n = iFieldArray.length;
            n3 = 0;
            while (n3 < n) {
                IField method = iFieldArray[n3];
                annotation = this.getAnnotation((IJavaElement)method, qualifiedName);
                if (annotation != null) {
                    return method;
                }
                ILocalVariable[] iLocalVariableArray = method.getParameters();
                int n4 = iLocalVariableArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    ILocalVariable parameter = iLocalVariableArray[n5];
                    annotation = this.getAnnotation((IJavaElement)parameter, qualifiedName);
                    if (annotation != null) {
                        return parameter;
                    }
                    ++n5;
                }
                ++n3;
            }
        }
        if (element instanceof IMember && (annotation = this.getAnnotation((IJavaElement)((IMember)element).getDeclaringType(), qualifiedName)) != null) {
            return ((IMember)element).getDeclaringType();
        }
        return null;
    }
}

