/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.quickfix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.jboss.tools.common.quickfix.IQuickFixGenerator;
import org.jboss.tools.common.quickfix.QuickFixExtension;

public class QuickFixManager {
    private static QuickFixManager instance = null;
    private HashMap<String, IQuickFixGenerator> generators = new HashMap();

    public static QuickFixManager getInstance() {
        if (instance == null) {
            instance = new QuickFixManager();
        }
        return instance;
    }

    public QuickFixManager() {
        QuickFixExtension[] extensions;
        QuickFixExtension[] quickFixExtensionArray = extensions = QuickFixExtension.getInstances();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            QuickFixExtension extension = quickFixExtensionArray[n2];
            IQuickFixGenerator generator = extension.getQuickFixGenerator();
            if (generator != null) {
                this.addQuickFixGenerator(generator);
            }
            ++n2;
        }
    }

    public void addQuickFixGenerator(IQuickFixGenerator generator) {
        if (!this.generators.containsKey(generator.getClass().toString())) {
            this.generators.put(generator.getClass().toString(), generator);
        }
    }

    public void removeQuickFixGenerator(IQuickFixGenerator generator) {
        this.generators.remove(generator);
    }

    public boolean hasProposals(Annotation annotation, Position position) {
        for (IQuickFixGenerator generator : this.generators.values()) {
            if (!generator.hasProposals(annotation, position)) continue;
            return true;
        }
        return false;
    }

    public List<IJavaCompletionProposal> getProposals(Annotation annotation, Position position) {
        ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
        for (IQuickFixGenerator generator : this.generators.values()) {
            IJavaCompletionProposal[] pp;
            IJavaCompletionProposal[] iJavaCompletionProposalArray = pp = generator.getProposals(annotation, position);
            int n = pp.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaCompletionProposal p = iJavaCompletionProposalArray[n2];
                proposals.add(p);
                ++n2;
            }
        }
        return proposals;
    }
}

