/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.discovery.core.internal.connectors;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.mylyn.internal.discovery.core.model.AbstractDiscoveryStrategy;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDiscovery;
import org.jboss.tools.discovery.core.internal.DiscoveryActivator;
import org.jboss.tools.discovery.core.internal.connectors.ChainedDiscoveryStrategy;
import org.jboss.tools.discovery.core.internal.connectors.ExpressionBasedBundleDiscoveryStrategy;
import org.jboss.tools.discovery.core.internal.connectors.ExpressionBasedRemoteBundleDiscoveryStrategy;

public class DiscoveryUtil {
    private DiscoveryUtil() {
    }

    public static ConnectorDiscovery createConnectorDiscovery() {
        String directoryUrl = DiscoveryActivator.getDefault().getJBossDiscoveryDirectory();
        return DiscoveryUtil.createConnectorDiscovery(directoryUrl);
    }

    public static ConnectorDiscovery createConnectorDiscovery(String directoryUrl) {
        ConnectorDiscovery connectorDiscovery = new ConnectorDiscovery();
        ChainedDiscoveryStrategy chainedDiscoveryStrategy = new ChainedDiscoveryStrategy(new ChainedDiscoveryStrategy.DiscoveryConnectorCollector());
        if (directoryUrl != null) {
            ExpressionBasedRemoteBundleDiscoveryStrategy remoteDiscoveryStrategy = new ExpressionBasedRemoteBundleDiscoveryStrategy();
            remoteDiscoveryStrategy.setDirectoryUrl(directoryUrl);
            chainedDiscoveryStrategy.addStrategy(remoteDiscoveryStrategy);
        }
        chainedDiscoveryStrategy.addStrategy((AbstractDiscoveryStrategy)new ExpressionBasedBundleDiscoveryStrategy());
        connectorDiscovery.getDiscoveryStrategies().add(chainedDiscoveryStrategy);
        connectorDiscovery.setVerifyUpdateSiteAvailability(true);
        connectorDiscovery.setEnvironment(DiscoveryUtil.getEnvironment());
        return connectorDiscovery;
    }

    private static Dictionary<Object, Object> getEnvironment() {
        Hashtable<Object, Object> environment = new Hashtable<Object, Object>(System.getProperties());
        return environment;
    }
}

