/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.discovery.core.internal.connectors.xpl;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.spi.RegistryStrategy;
import org.eclipse.mylyn.internal.discovery.core.model.AbstractDiscoverySource;
import org.eclipse.mylyn.internal.discovery.core.model.Directory;
import org.eclipse.mylyn.internal.discovery.core.model.JarDiscoverySource;
import org.eclipse.mylyn.internal.discovery.core.model.Policy;
import org.jboss.tools.discovery.core.internal.connectors.xpl.BundleDiscoveryStrategy;
import org.jboss.tools.discovery.core.internal.connectors.xpl.DiscoveryRegistryStrategy;

public class ExternalBundleDiscoveryStrategy
extends BundleDiscoveryStrategy {
    private DiscoveryRegistryStrategy registryStrategy;
    private int maxDiscoveryJarDownloadAttempts = 1;
    private File storageFolder;
    private boolean deleteStorageFolderOnFailure;

    public File getStorageFolder() throws CoreException {
        return this.storageFolder;
    }

    public void setStorageFolder(File storageFolder) {
        this.storageFolder = storageFolder;
    }

    public void setDeleteStorageFolderOnFailure(boolean deleteOnFailure) {
        this.deleteStorageFolderOnFailure = deleteOnFailure;
    }

    public boolean isDeleteStorageFolderOnFailure() {
        return this.deleteStorageFolderOnFailure;
    }

    @Override
    public void performDiscovery(IProgressMonitor monitor) throws CoreException {
        block20: {
            if (this.connectors == null || this.categories == null) {
                throw new IllegalStateException();
            }
            if (this.registryStrategy != null) {
                throw new IllegalStateException();
            }
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            int totalTicks = 100000;
            int ticksTenPercent = 10000;
            File storageDirectory = null;
            try {
                storageDirectory = this.getStorageFolder();
                if (storageDirectory == null) {
                    throw new IllegalStateException("storageDirectory not defined");
                }
                if (!storageDirectory.exists() && !storageDirectory.mkdirs()) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.discovery.core", "IO failure: cannot create storage area"));
                }
                File registryCacheFolder = this.getRegistryCacheFolder(storageDirectory);
                if (monitor.isCanceled()) {
                    return;
                }
                try {
                    Map<File, Directory.Entry> bundleFileToDirectoryEntry = this.loadRegistry(storageDirectory, monitor);
                    if (bundleFileToDirectoryEntry == null) break block20;
                    try {
                        this.registryStrategy = new DiscoveryRegistryStrategy(new File[]{registryCacheFolder}, new boolean[1], (Object)this);
                        this.registryStrategy.setExtensionPointProviderBundleIds(this.getExtensionPointProviderBundleIds());
                        this.registryStrategy.setBundles(bundleFileToDirectoryEntry);
                        ExtensionRegistry extensionRegistry = new ExtensionRegistry((RegistryStrategy)this.registryStrategy, (Object)this, (Object)this);
                        try {
                            IExtension[] extensions;
                            IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(this.getExtensionPointId());
                            if (extensionPoint != null && (extensions = extensionPoint.getExtensions()).length > 0) {
                                this.processExtensions((IProgressMonitor)new SubProgressMonitor(monitor, 30000), extensions);
                            }
                        }
                        finally {
                            extensionRegistry.stop((Object)this);
                        }
                    }
                    finally {
                        this.registryStrategy = null;
                    }
                }
                catch (CoreException e) {
                    if (this.deleteStorageFolderOnFailure && storageDirectory != null) {
                        this.delete(storageDirectory);
                    }
                    throw e;
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    protected File getRegistryCacheFolder(File storageFolder) throws CoreException {
        File registryCacheFolder = null;
        try {
            registryCacheFolder = new File(storageFolder, ".rcache");
            if (!registryCacheFolder.exists() && !registryCacheFolder.mkdirs()) {
                throw new IOException();
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.discovery.core", "IO failure: cannot create temporary registry area", (Throwable)e));
        }
        return registryCacheFolder;
    }

    protected Map<File, Directory.Entry> loadRegistry(File storageDirectory, IProgressMonitor monitor) throws CoreException {
        int totalTicks = 100000;
        monitor.beginTask("Local discovery", 100000);
        HashMap<File, Directory.Entry> bundleFileToDirectoryEntry = new HashMap<File, Directory.Entry>();
        File[] fileArray = storageDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                boolean accept = f.isFile() && f.canRead() && f.length() > 0L && f.getName().endsWith(".jar");
                return accept;
            }
        });
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            Directory.Entry entry = new Directory.Entry();
            entry.setLocation(f.getAbsolutePath());
            bundleFileToDirectoryEntry.put(f, entry);
            ++n2;
        }
        return bundleFileToDirectoryEntry;
    }

    private void delete(File file) {
        if (file.exists()) {
            File[] children;
            if (file.isDirectory() && (children = file.listFiles()) != null) {
                File[] fileArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    this.delete(child);
                    ++n2;
                }
            }
            file.delete();
        }
    }

    @Override
    protected AbstractDiscoverySource computeDiscoverySource(IContributor contributor) {
        Directory.Entry directoryEntry = this.registryStrategy.getDirectoryEntry(contributor);
        Policy policy = new Policy(directoryEntry.isPermitCategories());
        JarDiscoverySource discoverySource = new JarDiscoverySource(contributor.getName(), this.registryStrategy.getJarFile(contributor));
        discoverySource.setPolicy(policy);
        return discoverySource;
    }

    public int getMaxDiscoveryJarDownloadAttempts() {
        return this.maxDiscoveryJarDownloadAttempts;
    }

    public void setMaxDiscoveryJarDownloadAttempts(int maxDiscoveryJarDownloadAttempts) {
        if (maxDiscoveryJarDownloadAttempts < 1 || maxDiscoveryJarDownloadAttempts > 2) {
            throw new IllegalArgumentException();
        }
        this.maxDiscoveryJarDownloadAttempts = maxDiscoveryJarDownloadAttempts;
    }

    protected String[] getExtensionPointProviderBundleIds() {
        return new String[]{"org.eclipse.mylyn.discovery.core"};
    }
}

