/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.projects;

import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.furnace.util.Assert;

public final class Projects {
    private static boolean cacheDisabledFlag = Boolean.getBoolean("PROJECT_CACHE_DISABLED");

    public static Project getSelectedProject(ProjectFactory projectFactory, UIContext context) {
        return Projects.getSelectedProject(projectFactory, context.getSelection());
    }

    public static Project getSelectedProject(ProjectFactory projectFactory, UISelection<?> selection) {
        Assert.notNull((Object)projectFactory, (String)"Project Factory cannot be null");
        Project project = null;
        if (!selection.isEmpty() && selection.get() instanceof Resource) {
            Resource resource = (Resource)selection.get();
            project = projectFactory.findProject(resource);
        }
        return project;
    }

    public static boolean containsProject(ProjectFactory projectFactory, UIContext context) {
        Assert.notNull((Object)projectFactory, (String)"Project Factory cannot be null");
        UISelection selection = context.getInitialSelection();
        if (!selection.isEmpty() && selection.get() instanceof Resource) {
            return projectFactory.containsProject((Resource)selection.get());
        }
        return false;
    }

    public static void enableCache() {
        cacheDisabledFlag = false;
    }

    public static void disableCache() {
        cacheDisabledFlag = true;
    }

    public static boolean isCacheDisabled() {
        return cacheDisabledFlag;
    }
}

