/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.projects.stacks;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.forge.addon.projects.ProjectFacet;

public interface Stack {
    public String getName();

    default public boolean supports(Class<? extends ProjectFacet> facet) {
        Set<Class<? extends ProjectFacet>> excludedFacets = this.getExcludedFacets();
        return this.getIncludedFacets().stream().anyMatch(includedFacet -> facet.isAssignableFrom((Class<?>)includedFacet) && !excludedFacets.contains(includedFacet));
    }

    default public boolean matches(Class<? extends ProjectFacet> facet) {
        return this.getIncludedFacets().contains(facet) && !this.getExcludedFacets().contains(facet);
    }

    default public <T extends ProjectFacet> Set<T> filter(Class<T> type, Iterable<T> facets) {
        Set<Class<? extends ProjectFacet>> excludedFacets = this.getExcludedFacets();
        Set sameTypeFacets = this.getIncludedFacets().stream().filter(f -> type.isAssignableFrom((Class<?>)f) && !excludedFacets.contains(f)).collect(Collectors.toSet());
        LinkedHashSet<ProjectFacet> result = new LinkedHashSet<ProjectFacet>();
        block0: for (ProjectFacet facet : facets) {
            for (Class thisStackFacet : sameTypeFacets) {
                if (!thisStackFacet.isInstance(facet)) continue;
                result.add(facet);
                continue block0;
            }
        }
        return result;
    }

    public Set<Class<? extends ProjectFacet>> getIncludedFacets();

    public Set<Class<? extends ProjectFacet>> getExcludedFacets();
}

