/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.projects.ui;

import java.util.Optional;
import java.util.Set;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.facets.constraints.FacetInspector;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFacet;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.Projects;
import org.jboss.forge.addon.projects.stacks.Stack;
import org.jboss.forge.addon.projects.stacks.StackInspector;
import org.jboss.forge.addon.ui.command.AbstractUICommand;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.input.UISelectOne;

public abstract class AbstractProjectCommand
extends AbstractUICommand {
    public boolean isEnabled(UIContext context) {
        return this.isProjectRequired() && this.containsProject(context) && this.constraintsSatisfied(context) && super.isEnabled(context) || !this.isProjectRequired() && super.isEnabled(context);
    }

    private boolean constraintsSatisfied(UIContext context) {
        Class type = this.getMetadata(context).getType();
        Project project = this.getSelectedProject(context);
        Set facets = FacetInspector.getRequiredFacets((Class)type);
        Set<Class<ProjectFacet>> stackFacets = StackInspector.getAllRelatedFacets(type);
        return FacetInspector.isConstraintSatisfied((Faceted)project, (Set)facets) && StackInspector.isConstraintSatisfied(project, stackFacets);
    }

    protected abstract boolean isProjectRequired();

    protected boolean containsProject(UIContext context) {
        return Projects.containsProject(this.getProjectFactory(), context);
    }

    protected Project getSelectedProject(UIContextProvider contextProvider) {
        return this.getSelectedProject(contextProvider.getUIContext());
    }

    protected Project getSelectedProject(UIContext context) {
        Project selectedProject = Projects.getSelectedProject(this.getProjectFactory(), context);
        if (this.isProjectRequired() && selectedProject == null) {
            throw new IllegalStateException("A project is required in the current context");
        }
        return selectedProject;
    }

    protected abstract ProjectFactory getProjectFactory();

    protected <T extends ProjectFacet> boolean filterValueChoicesFromStack(Project project, UISelectOne<T> select) {
        boolean result = true;
        Optional<Stack> stackOptional = project.getStack();
        if (stackOptional.isPresent()) {
            Stack stack = stackOptional.get();
            Iterable valueChoices = select.getValueChoices();
            Set filter = stack.filter(select.getValueType(), valueChoices);
            select.setValueChoices(filter);
            if (filter.size() == 1) {
                select.setDefaultValue(filter.iterator().next());
                result = false;
            } else if (filter.size() == 0) {
                result = false;
            }
        }
        return result;
    }
}

