/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.notifications.internal;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.forge.ui.notifications.internal.NotificationConstants;

public class NotificationHelper {
    private NotificationHelper() {
    }

    public static void fadeIn(Shell shell) {
        Display.getDefault().timerExec(NotificationConstants.FADE_TIMER, (Runnable)new FadeInRunnable(shell));
    }

    private static void startTimer(final Shell shell) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (shell == null || shell.isDisposed()) {
                    return;
                }
                NotificationHelper.fadeOut(shell);
            }
        };
        Display.getDefault().timerExec(NotificationConstants.DISPLAY_TIME, run);
    }

    private static void fadeOut(Shell shell) {
        Display.getDefault().timerExec(NotificationConstants.FADE_TIMER, (Runnable)new FadeOutRunnable(shell));
    }

    private static class FadeInRunnable
    implements Runnable {
        private Shell shell;
        private int currentAlpha = 0;

        public FadeInRunnable(Shell shell) {
            this.shell = shell;
        }

        @Override
        public void run() {
            if (this.shell == null || this.shell.isDisposed()) {
                return;
            }
            this.currentAlpha += NotificationConstants.FADE_IN_STEP;
            if (this.currentAlpha > NotificationConstants.FINAL_ALPHA) {
                this.shell.setAlpha(NotificationConstants.FINAL_ALPHA);
                NotificationHelper.startTimer(this.shell);
                return;
            }
            this.shell.setAlpha(this.currentAlpha);
            Display.getDefault().timerExec(NotificationConstants.FADE_TIMER, (Runnable)this);
        }
    }

    private static class FadeOutRunnable
    implements Runnable {
        private Shell shell;
        private int currentAlpha = NotificationConstants.FINAL_ALPHA;

        public FadeOutRunnable(Shell shell) {
            this.shell = shell;
        }

        @Override
        public void run() {
            if (this.shell == null || this.shell.isDisposed()) {
                return;
            }
            this.currentAlpha -= NotificationConstants.FADE_OUT_STEP;
            if (this.currentAlpha <= 0) {
                this.shell.setAlpha(0);
                this.shell.dispose();
                return;
            }
            this.shell.setAlpha(this.currentAlpha);
            Display.getDefault().timerExec(NotificationConstants.FADE_TIMER, (Runnable)this);
        }
    }
}

