/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.ext.context;

import java.util.Optional;
import org.eclipse.jface.text.ITextSelection;
import org.jboss.forge.addon.ui.context.UIRegion;
import org.jboss.forge.furnace.util.Assert;

public class UIRegionImpl<T>
implements UIRegion<T> {
    private final T resource;
    private final ITextSelection textSelection;

    public UIRegionImpl(T resource, ITextSelection textSelection) {
        Assert.notNull((Object)textSelection, (String)"Text selection cannot be null");
        this.textSelection = textSelection;
        this.resource = resource;
    }

    public int getEndPosition() {
        int length = this.textSelection.getLength();
        return length == -1 ? -1 : this.textSelection.getOffset() + length;
    }

    public int getStartLine() {
        int startLine = this.textSelection.getStartLine();
        return startLine == -1 ? -1 : startLine + 1;
    }

    public int getEndLine() {
        int endLine = this.textSelection.getEndLine();
        return endLine == -1 ? -1 : endLine + 1;
    }

    public int getStartPosition() {
        return this.textSelection.getOffset();
    }

    public Optional<String> getText() {
        return Optional.ofNullable(this.textSelection.getText());
    }

    public T getResource() {
        return this.resource;
    }
}

