/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.ext.control;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.convert.ConverterFactory;
import org.jboss.forge.addon.ui.controller.CommandController;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.util.InputComponents;
import org.jboss.forge.furnace.util.Sets;
import org.jboss.tools.forge.core.furnace.FurnaceService;
import org.jboss.tools.forge.ui.internal.ext.control.ControlBuilder;
import org.jboss.tools.forge.ui.internal.ext.wizards.ForgeWizardPage;

public class ComboControlBuilder
extends ControlBuilder<Combo> {
    private static final Set<Combo> COMBO_STATUS_CHANGE = Sets.getConcurrentSet();

    @Override
    public Combo build(ForgeWizardPage page, InputComponent<?, ?> input, final String inputName, Composite container) {
        final CommandController controller = page.getController();
        Label label = new Label(container, 0);
        label.setText(this.getMnemonicLabel(input, true));
        label.setToolTipText(input.getDescription());
        final Combo combo = new Combo(container, 2060);
        combo.setData("forge.label", (Object)label);
        combo.setLayoutData((Object)new GridData(768));
        combo.setToolTipText(input.getDescription());
        Label dummy = new Label(container, 0);
        dummy.setText("");
        this.updateValues(combo, input);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = combo.getText();
                controller.setValueFor(inputName, (Object)text);
            }
        });
        return combo;
    }

    @Override
    public void setEnabled(Combo control, boolean enabled) {
        if (enabled != control.isEnabled()) {
            control.setEnabled(enabled);
        }
    }

    @Override
    protected Class<Object> getProducedType() {
        return Object.class;
    }

    @Override
    protected String getSupportedInputType() {
        return "org.jboss.forge.inputType.DROPDOWN";
    }

    @Override
    protected Class<?>[] getSupportedInputComponentTypes() {
        return new Class[]{UISelectOne.class};
    }

    @Override
    public Control[] getModifiableControlsFor(Combo control) {
        return new Control[]{control};
    }

    @Override
    public void updateState(Combo combo, InputComponent<?, ?> input) {
        if (!COMBO_STATUS_CHANGE.add(combo)) {
            return;
        }
        try {
            super.updateState(combo, input);
            this.updateValues(combo, input);
        }
        finally {
            COMBO_STATUS_CHANGE.remove(combo);
        }
    }

    private Converter<Object, String> getConverter(UISelectOne<Object> selectOne) {
        return InputComponents.getItemLabelConverter((ConverterFactory)FurnaceService.INSTANCE.getConverterFactory(), selectOne);
    }

    private void updateValues(Combo combo, InputComponent<?, ?> input) {
        UISelectOne selectOne = (UISelectOne)input;
        this.updateValueChoices(combo, (UISelectOne<Object>)selectOne);
        this.updateDefaultValue(combo, (UISelectOne<Object>)selectOne);
    }

    private void updateDefaultValue(Combo combo, UISelectOne<Object> selectOne) {
        String value;
        Converter<Object, String> converter = this.getConverter(selectOne);
        Object inputValue = InputComponents.getValueFor(selectOne);
        String string = value = inputValue == null ? null : (String)converter.convert(inputValue);
        if (value == null) {
            combo.setText("");
        } else if (!value.equals(combo.getText())) {
            combo.setText(value);
        }
    }

    private void updateValueChoices(Combo combo, UISelectOne<Object> selectOne) {
        Object[] oldItems;
        int newSize;
        Object[] newItemsArray;
        ArrayList<String> newItems = new ArrayList<String>();
        Iterable valueChoices = selectOne.getValueChoices();
        Converter<Object, String> converter = this.getConverter(selectOne);
        if (valueChoices != null) {
            for (Object choice : valueChoices) {
                String itemLabel = (String)converter.convert(choice);
                newItems.add(itemLabel);
            }
        }
        if (!Arrays.equals(newItemsArray = newItems.toArray(new String[newSize = newItems.size()]), oldItems = combo.getItems())) {
            String currentValue;
            Object value = selectOne.getValue();
            String string = currentValue = value == null ? null : (String)converter.convert(value);
            if (!Arrays.asList(newItemsArray).contains(currentValue)) {
                selectOne.setValue(null);
            }
            combo.setItems((String[])newItemsArray);
        }
    }
}

