/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.ext.control;

import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.rse.ui.Mnemonics;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.jboss.forge.addon.convert.ConverterFactory;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.util.InputComponents;
import org.jboss.forge.furnace.util.Strings;
import org.jboss.tools.forge.core.furnace.FurnaceService;
import org.jboss.tools.forge.ui.internal.ext.autocomplete.InputComponentProposalProvider;
import org.jboss.tools.forge.ui.internal.ext.context.UIContextImpl;
import org.jboss.tools.forge.ui.internal.ext.wizards.ForgeWizardPage;

public abstract class ControlBuilder<CONTROL extends Control> {
    protected static final String LABEL_DATA_KEY = "forge.label";
    private static final String NOTE_DATA_KEY = "forge.note";

    public abstract CONTROL build(ForgeWizardPage var1, InputComponent<?, ?> var2, String var3, Composite var4);

    protected abstract Class<?> getProducedType();

    protected abstract String getSupportedInputType();

    protected abstract Class<?>[] getSupportedInputComponentTypes();

    public boolean handles(InputComponent<?, ?> input) {
        boolean handles = false;
        Class<?>[] classArray = this.getSupportedInputComponentTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> inputType = classArray[n2];
            if (inputType.isInstance(input)) {
                handles = true;
                break;
            }
            ++n2;
        }
        if (handles) {
            String inputTypeHint = InputComponents.getInputType(input);
            handles = inputTypeHint != null && !inputTypeHint.equals("org.jboss.forge.inputType.DEFAULT") ? inputTypeHint.equals(this.getSupportedInputType()) : this.getProducedType().isAssignableFrom(input.getValueType());
        }
        return handles;
    }

    public void setEnabled(CONTROL control, boolean enabled) {
        if (control instanceof Composite) {
            Composite c = (Composite)control;
            Control[] controlArray = c.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.setEnabled(enabled);
                ++n2;
            }
        } else {
            control.setEnabled(enabled);
        }
    }

    public Control[] getModifiableControlsFor(CONTROL control) {
        if (control instanceof Composite) {
            return ((Composite)control).getChildren();
        }
        return new Control[]{control};
    }

    protected ContentProposalAdapter setupAutoCompleteForText(UIContextImpl context, InputComponent<?, ?> input, UICompleter<?> completer, Text text) {
        ContentProposalAdapter result = null;
        if (completer != null) {
            ControlDecoration dec = new ControlDecoration((Control)text, 16512);
            FieldDecoration completerIndicator = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
            dec.setImage(completerIndicator.getImage());
            dec.setDescriptionText(completerIndicator.getDescription());
            KeyStroke activationKeyStroke = KeyStroke.getInstance((int)262144, (int)32);
            result = new ContentProposalAdapter((Control)text, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new InputComponentProposalProvider(context, input, completer), activationKeyStroke, null);
            result.setProposalAcceptanceStyle(2);
        }
        return result;
    }

    public void setupNote(Composite parent, Control control, InputComponent<?, ?> input) {
        Label placeholder = new Label(parent, 0);
        GridData layoutData = new GridData();
        layoutData.heightHint = 0;
        placeholder.setLayoutData((Object)layoutData);
        Label notes = new Label(parent, 64);
        control.setData(NOTE_DATA_KEY, (Object)notes);
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        notes.setLayoutData((Object)layoutData);
        String note = input.getNote();
        if (Strings.isNullOrEmpty((String)note)) {
            layoutData.heightHint = 0;
        } else {
            notes.setText(note);
        }
    }

    protected String getMnemonicLabel(InputComponent<?, ?> input, boolean addColon) {
        String label = InputComponents.getLabelFor(input, (boolean)addColon);
        char shortName = input.getShortName();
        if (shortName != ' ') {
            label = Mnemonics.applyMnemonic((String)label, (char)shortName);
        }
        return label;
    }

    public void updateState(CONTROL control, InputComponent<?, ?> input) {
        this.setEnabled(control, input.isEnabled());
        this.setNote(control, input.getNote());
        this.setLabelTooltip(control, input.getDescription());
    }

    protected void setNote(CONTROL control, String note) {
        boolean changed;
        Label notes = (Label)control.getData(NOTE_DATA_KEY);
        GridData gridData = (GridData)notes.getLayoutData();
        boolean bl = changed = !notes.getText().equals(note);
        if (Strings.isNullOrEmpty((String)note)) {
            gridData.heightHint = 0;
            notes.setText("");
        } else {
            gridData.heightHint = -1;
            notes.setText(note);
        }
        if (changed) {
            notes.getParent().layout();
            notes.getParent().redraw();
        }
    }

    protected void setLabelTooltip(CONTROL control, String tooltip) {
        Label label = (Label)control.getData(LABEL_DATA_KEY);
        if (label != null) {
            label.setToolTipText(tooltip);
        }
    }

    protected ConverterFactory getConverterFactory() {
        return FurnaceService.INSTANCE.getConverterFactory();
    }
}

