/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.ext.database;

import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;

public class ConnectionProfileUtil {
    private ConnectionProfileUtil() {
    }

    public static String getDriverDefinitionId(IConnectionProfile profile) {
        if (profile == null) {
            return null;
        }
        return profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.driverDefinitionID");
    }

    public static DriverInstance getDriverDefinition(String connectionProfile) {
        if (connectionProfile == null) {
            return null;
        }
        IConnectionProfile profile = ProfileManager.getInstance().getProfileByName(connectionProfile);
        if (profile == null) {
            return null;
        }
        String driverID = ConnectionProfileUtil.getDriverDefinitionId(profile);
        return DriverManager.getInstance().getDriverInstanceByID(driverID);
    }

    public static String[] getConnectionProfileDriverURL(String connectionProfile) {
        DriverInstance di = ConnectionProfileUtil.getDriverDefinition(connectionProfile);
        if (di == null) {
            return null;
        }
        return di.getJarListAsArray();
    }

    public static String getDriverClass(String connectionProfile) {
        DriverInstance di = ConnectionProfileUtil.getDriverDefinition(connectionProfile);
        String driverClass = di != null ? di.getProperty("org.eclipse.datatools.connectivity.db.driverClass") : "";
        return driverClass;
    }
}

