/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.ext.importer;

import java.util.HashSet;
import java.util.Set;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectListener;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.tools.forge.ui.internal.ForgeUIPlugin;
import org.jboss.tools.forge.ui.internal.ext.context.UIContextImpl;
import org.jboss.tools.forge.ui.internal.ext.importer.ProjectImporter;
import org.jboss.tools.forge.ui.internal.ext.wizards.WizardListener;

public enum ImportEclipseProjectListener implements ProjectListener,
WizardListener
{
    INSTANCE;

    private Set<Project> projects = new HashSet<Project>();

    public void projectCreated(Project project) {
        this.projects.add(project);
    }

    public boolean projectsAvailableForImport() {
        return !this.projects.isEmpty();
    }

    public void doImport() {
        try {
            try {
                for (Project project : this.projects) {
                    Resource projectRoot = project.getRoot();
                    String baseDirPath = projectRoot.getParent().getFullyQualifiedName();
                    String moduleLocation = projectRoot.getName();
                    String projectName = ((MetadataFacet)project.getFacet(MetadataFacet.class)).getProjectName();
                    ProjectImporter projectImporter = new ProjectImporter(baseDirPath, moduleLocation, projectName);
                    projectImporter.importProject();
                }
            }
            catch (Exception e) {
                ForgeUIPlugin.log(e);
                this.projects.clear();
            }
        }
        finally {
            this.projects.clear();
        }
    }

    @Override
    public void onFinish(UIContextImpl context) {
        this.doImport();
    }

    @Override
    public void dispose() {
        this.projects.clear();
    }
}

