/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.ext.provider;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.ide.IDE;
import org.jboss.forge.addon.ui.DefaultUIDesktop;
import org.jboss.tools.forge.ui.internal.ForgeUIPlugin;

public class ForgeUIDesktop
extends DefaultUIDesktop {
    public void open(File file) throws IOException {
        this.edit(file);
    }

    public void edit(File file) throws IOException {
        final IFileStore fileStore = EFS.getLocalFileSystem().getStore(file.toURI());
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            window = workbench.getWorkbenchWindows()[0];
        }
        final IWorkbenchPage page = window.getActivePage();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                }
                catch (PartInitException e) {
                    Status status = new Status(4, "org.jboss.tools.forge.ui", "Edit File action failed");
                    ForgeUIPlugin.log(e);
                    MessageDialog.openError(null, (String)"Edit File", (String)status.getMessage());
                }
            }
        });
    }

    public void browse(URI uri) throws IOException {
        final URL url = uri.toURL();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                try {
                    IWebBrowser browser = support.createBrowser("org.jboss.tools.forge.ui");
                    browser.openURL(url);
                }
                catch (PartInitException e) {
                    Status status = new Status(4, "org.jboss.tools.forge.ui", "Browser initialization failed");
                    ForgeUIPlugin.log(e);
                    MessageDialog.openError(null, (String)"Browse URL", (String)status.getMessage());
                }
            }
        });
    }
}

