/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.jobs;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Optional;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.BlockTextSelection;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.ui.view.IRSEViewPart;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.forge.addon.ui.context.UIRegion;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.tools.forge.ui.internal.ForgeUIPlugin;
import org.jboss.tools.forge.ui.internal.ext.context.UIContextImpl;
import org.jboss.tools.forge.ui.internal.jobs.ChainedWorkspaceJob;

public class ShowFinalSelectionJob
extends ChainedWorkspaceJob {
    private UIContextImpl context;

    public ShowFinalSelectionJob() {
        super("Show Final Selection");
    }

    public void setContext(UIContextImpl context) {
        this.context = context;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        UISelection selection = this.context.getSelection();
        if (selection != null && !selection.isEmpty()) {
            this.selectResourceFor(selection.get(), selection.getRegion());
        }
        return Status.OK_STATUS;
    }

    private void selectResourceFor(Object object, Optional<UIRegion<Object>> region) {
        try {
            Object resource;
            Method method = object.getClass().getMethod("getUnderlyingResourceObject", new Class[0]);
            if (method != null && (resource = method.invoke(object, new Object[0])) != null && resource instanceof File) {
                Display.getDefault().asyncExec(() -> this.selectFile((File)resource, region));
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            ForgeUIPlugin.log(e);
        }
    }

    private void selectFile(File file, Optional<UIRegion<Object>> region) {
        try {
            Path path = new Path(file.getCanonicalPath());
            IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)path);
            IFileInfo fileInfo = fileStore.fetchInfo();
            if (!fileInfo.exists()) {
                return;
            }
            Object resource = null;
            resource = fileInfo.isDirectory() ? ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)path) : ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            if (resource != null) {
                this.expandWorkspaceResource((IResource)resource);
            } else {
                this.expandSystemDirectory(fileStore);
            }
            if (!fileInfo.isDirectory()) {
                this.openFileInEditor(fileStore, region);
            }
        }
        catch (IOException e) {
            ForgeUIPlugin.log(e);
        }
    }

    private void expandWorkspaceResource(IResource container) {
        IWorkbenchPage workbenchPage = this.getActiveWorkbenchPage();
        if (workbenchPage != null) {
            IViewPart packageExplorer;
            this.refreshWorkspaceResource(container);
            IViewPart projectExplorer = workbenchPage.findView("org.eclipse.ui.navigator.ProjectExplorer");
            if (projectExplorer != null && projectExplorer instanceof CommonNavigator) {
                this.expandInProjectExplorer((CommonNavigator)projectExplorer, container);
            }
            if ((packageExplorer = workbenchPage.findView("org.eclipse.jdt.ui.PackageExplorer")) != null) {
                this.expandInPackageExplorer(packageExplorer, container);
            }
        }
    }

    private void expandSystemDirectory(IFileStore fileStore) {
        IWorkbenchPage workbenchPage = this.getActiveWorkbenchPage();
        IViewPart remoteSystemView = workbenchPage.findView("org.eclipse.rse.ui.view.systemView");
        if (remoteSystemView != null) {
            this.expandInRemoteSystemView(remoteSystemView, fileStore);
        }
    }

    private void openFileInEditor(IFileStore fileStore, Optional<UIRegion<Object>> region) {
        try {
            IEditorPart editorPart;
            IWorkbenchPage workbenchPage = this.getActiveWorkbenchPage();
            if (workbenchPage != null && (editorPart = IDE.openEditorOnFileStore((IWorkbenchPage)workbenchPage, (IFileStore)fileStore)) instanceof ITextEditor) {
                ITextEditor itextEditor = (ITextEditor)editorPart;
                region.ifPresent(r -> {
                    IDocument doc = itextEditor.getDocumentProvider().getDocument((Object)itextEditor.getEditorInput());
                    BlockTextSelection selection = new BlockTextSelection(doc, r.getStartLine() - 1, r.getStartPosition(), r.getEndLine() - 1, r.getEndPosition(), 1);
                    ISelectionProvider selectionProvider = itextEditor.getSelectionProvider();
                    selectionProvider.setSelection((ISelection)selection);
                });
            }
        }
        catch (PartInitException e) {
            ForgeUIPlugin.log(e);
        }
    }

    private IWorkbenchPage getActiveWorkbenchPage() {
        IWorkbenchPage result = null;
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow != null) {
            result = workbenchWindow.getActivePage();
        }
        return result;
    }

    private void refreshWorkspaceResource(IResource container) {
        try {
            container.refreshLocal(2, null);
        }
        catch (CoreException e) {
            ForgeUIPlugin.log(e);
        }
    }

    private void expandInProjectExplorer(CommonNavigator projectExplorer, IResource container) {
        projectExplorer.selectReveal((ISelection)new StructuredSelection((Object)container));
        CommonViewer treeViewer = projectExplorer.getCommonViewer();
        treeViewer.expandToLevel((Object)container, 1);
    }

    private void expandInPackageExplorer(IViewPart packageExplorer, IResource container) {
        Object treeViewer;
        if (packageExplorer instanceof ISetSelectionTarget) {
            ((ISetSelectionTarget)packageExplorer).selectReveal((ISelection)new StructuredSelection((Object)container));
        }
        if ((treeViewer = packageExplorer.getAdapter(ISelectionProvider.class)) != null && treeViewer instanceof TreeViewer) {
            ((TreeViewer)treeViewer).expandToLevel((Object)JavaCore.create((IResource)container), 1);
        }
    }

    private void expandInRemoteSystemView(IViewPart remoteSystemView, IFileStore fileStore) {
        Viewer viewer = this.getViewer(remoteSystemView);
        if (viewer == null) {
            return;
        }
        Object input = viewer.getInput();
        ArrayList<String> names = this.createSegmentNames(fileStore);
        ArrayList<Object> treeSegments = new ArrayList<Object>();
        block0: for (String name : names) {
            if (input instanceof IAdaptable) {
                ISystemViewElementAdapter adapter = SystemAdapterHelpers.getViewAdapter((Object)input);
                if (adapter == null) continue;
                Object[] objectArray = adapter.getChildren((IAdaptable)input, null);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof IAdaptable && (adapter = SystemAdapterHelpers.getViewAdapter((Object)object)) != null && name.equals(adapter.getText(object))) {
                        input = object;
                        treeSegments.add(input);
                        continue block0;
                    }
                    ++n2;
                }
                continue;
            }
            treeSegments.clear();
            break;
        }
        TreePath treePath = new TreePath(treeSegments.toArray());
        viewer.setSelection((ISelection)new StructuredSelection((Object)treePath));
        if (viewer instanceof TreeViewer) {
            ((TreeViewer)viewer).expandToLevel((Object)treePath, 1);
        }
    }

    private Viewer getViewer(IViewPart remoteSystemView) {
        if (remoteSystemView instanceof IRSEViewPart) {
            return ((IRSEViewPart)remoteSystemView).getRSEViewer();
        }
        return null;
    }

    private ArrayList<String> createSegmentNames(IFileStore fileStore) {
        ArrayList<String> result = new ArrayList<String>();
        while (fileStore.getParent() != null) {
            result.add(0, fileStore.getName());
            fileStore = fileStore.getParent();
        }
        result.add(0, "/");
        result.add(0, "Root");
        result.add(0, "Local Files");
        result.add(0, "Local");
        return result;
    }
}

