/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.core.jobs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.jboss.tools.foundation.core.internal.Trace;

public class BarrierProgressWaitJob
extends Job {
    private IRunnableWithProgress runnable;
    private Object[] barrier;
    private boolean throwableCaught = false;

    public BarrierProgressWaitJob(String name, IRunnableWithProgress runnable) {
        super(name);
        this.setSystem(true);
        this.runnable = runnable;
        this.barrier = new Object[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        Trace.trace("/finer", "Launching job " + this.getName() + ", a BarrierProgressWaitJob");
        try {
            Object ret = this.runnable.run(monitor);
            Object[] objectArray = this.barrier;
            synchronized (this.barrier) {
                this.barrier[0] = ret;
                this.barrier.notify();
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return Status.OK_STATUS;
            }
        }
        catch (Exception e) {
            Trace.trace("/finer", "Job " + this.getName() + ", a BarrierProgressWaitJob, failed with exception " + e.getMessage());
            this.throwableCaught = true;
            Object[] objectArray = this.barrier;
            synchronized (this.barrier) {
                this.barrier.notify();
                this.barrier[0] = e;
                // ** MonitorExit[var3_5] (shouldn't be in output)
                return Status.OK_STATUS;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void monitorSafeJoin(IProgressMonitor monitor) {
        boolean done = false;
        while (!done) {
            Object[] objectArray = this.barrier;
            // MONITORENTER : this.barrier
            try {
                this.barrier.wait(200L);
            }
            catch (InterruptedException interruptedException) {}
            if (this.barrier[0] != null || monitor.isCanceled()) {
                Trace.trace("/finer", "job " + this.getName() + ", a BarrierProgressWaitJob, is finished due to " + (this.barrier[0] != null ? "a non-null result" : "a canceled progress monitor"));
                done = true;
            }
            // MONITOREXIT : objectArray
        }
        if (!monitor.isCanceled()) return;
        Trace.trace("/finer", "Progress monitor for job " + this.getName() + ", a BarrierProgressWaitJob, has been canceled");
        this.cancel();
    }

    protected void canceling() {
        Thread t = this.getThread();
        if (t != null) {
            t.interrupt();
        }
    }

    public Throwable getThrowable() {
        if (this.throwableCaught && this.barrier[0] instanceof Throwable) {
            return (Exception)this.barrier[0];
        }
        return null;
    }

    public Object getReturnValue() {
        return this.throwableCaught ? null : this.barrier[0];
    }

    public static interface IRunnableWithProgress {
        public Object run(IProgressMonitor var1) throws Exception;
    }
}

