/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.core.plugin.log;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.jboss.tools.foundation.core.plugin.log.IPluginLog;
import org.jboss.tools.foundation.core.plugin.log.StatusFactory;

public class PluginLog
implements IPluginLog {
    private Plugin plugin;
    private String pluginId;

    public PluginLog(Plugin plugin) {
        this.plugin = plugin;
        this.pluginId = plugin.getBundle().getSymbolicName();
    }

    @Override
    public void logError(String message, Throwable t) {
        this.logStatus(StatusFactory.errorStatus(this.pluginId, message, t));
    }

    @Override
    public void logError(String message) {
        this.logStatus(StatusFactory.errorStatus(this.pluginId, message));
    }

    @Override
    public void logError(Throwable t) {
        this.logStatus(StatusFactory.errorStatus(this.pluginId, t.getMessage(), t));
    }

    @Override
    public void logWarning(String message, Throwable t) {
        this.logStatus(StatusFactory.warningStatus(this.pluginId, t.getMessage(), t));
    }

    @Override
    public void logWarning(String message) {
        this.logStatus(StatusFactory.warningStatus(this.pluginId, message));
    }

    @Override
    public void logWarning(Throwable t) {
        this.logStatus(StatusFactory.warningStatus(this.pluginId, t.getMessage(), t));
    }

    @Override
    public void logInfo(String message, Throwable t) {
        this.logStatus(StatusFactory.infoStatus(this.pluginId, t.getMessage(), t));
    }

    @Override
    public void logInfo(String message) {
        this.logStatus(StatusFactory.infoStatus(this.pluginId, message));
    }

    @Override
    public void logMessage(int code, String message, Throwable t) {
        if (t == null) {
            this.logInfo(message);
        } else {
            IStatus s = StatusFactory.throwableToStatus(this.plugin.getBundle().getSymbolicName(), t, code);
            this.logStatus(s);
        }
    }

    @Override
    public void logStatus(IStatus s) {
        this.plugin.getLog().log(s);
    }
}

