/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context;

import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.utility.internal.iterable.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterable.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SubIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.iterator.CloneListIterator;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.java.JavaGenerator;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.internal.GenericJpaJpqlQueryHelper;
import org.eclipse.jpt.jpa.core.internal.context.persistence.AbstractPersistenceUnit;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.persistence.GenericClassRef;
import org.eclipse.jpt.jpa.core.jpql.JpaJpqlQueryHelper;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaProject;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJptPlugin;
import org.jboss.tools.hibernate.jpt.core.internal.context.Messages;
import org.jboss.tools.hibernate.jpt.core.internal.context.basic.BasicHibernateProperties;
import org.jboss.tools.hibernate.jpt.core.internal.context.basic.Hibernate;
import org.jboss.tools.hibernate.jpt.core.internal.context.basic.HibernatePersistenceUnitProperties;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernatePackageInfo;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.JavaTypeDef;
import org.jboss.tools.hibernate.jpt.core.internal.context.persistence.HibernateClassRef;
import org.jboss.tools.hibernate.jpt.core.internal.context.persistence.HibernatePersistenceUnitPropertiesBuilder;
import org.jboss.tools.hibernate.jpt.core.internal.validation.HibernateJpaValidationMessage;

public class HibernatePersistenceUnit
extends AbstractPersistenceUnit
implements Messages,
Hibernate {
    public String TYPE_DEF_LIST = "typeDefs";
    private HibernatePersistenceUnitProperties hibernateProperties;
    protected final Vector<JavaTypeDef> typeDefs = new Vector();

    public HibernatePersistenceUnit(Persistence parent, XmlPersistenceUnit persistenceUnit) {
        super(parent, persistenceUnit);
    }

    public HibernateJpaProject getJpaProject() {
        return (HibernateJpaProject)super.getJpaProject();
    }

    protected void addNonUpdateAspectNamesTo(Set<String> nonUpdateAspectNames) {
        super.addNonUpdateAspectNamesTo(nonUpdateAspectNames);
        nonUpdateAspectNames.add(this.TYPE_DEF_LIST);
    }

    public void update(IProgressMonitor monitor) {
        this.typeDefs.clear();
        super.update(monitor);
        this.fireListChanged(this.TYPE_DEF_LIST, this.typeDefs);
    }

    protected void initializeProperties() {
        super.initializeProperties();
        this.hibernateProperties = ((HibernatePersistenceUnitPropertiesBuilder)this.getContextModelFactory()).buildHibernatePersistenceUnitProperties((PersistenceUnit)this);
    }

    public void propertyRemoved(String propertyName) {
        super.propertyRemoved(propertyName);
        this.hibernateProperties.propertyRemoved(propertyName);
    }

    public void propertyValueChanged(String propertyName, String newValue) {
        super.propertyValueChanged(propertyName, newValue);
        this.hibernateProperties.propertyValueChanged(propertyName, newValue);
    }

    public BasicHibernateProperties getHibernatePersistenceUnitProperties() {
        return this.hibernateProperties;
    }

    public ListIterator<JavaTypeDef> typeDefs() {
        return new CloneListIterator(this.typeDefs, CloneListIterator.Adapter.ReadOnly.instance());
    }

    public int typeDefsSize() {
        return this.typeDefs.size();
    }

    public void addTypeDef(JavaTypeDef typeDef) {
        this.typeDefs.add(typeDef);
    }

    public String[] uniqueTypeDefNames() {
        HashSet<String> names = new HashSet<String>(this.typeDefs.size());
        this.addNonNullTypeDefNamesTo(names);
        return names.toArray(new String[names.size()]);
    }

    public boolean hasTypeDef(String name) {
        ListIterator<JavaTypeDef> stream = this.typeDefs();
        while (stream.hasNext()) {
            String typeDefName = ((JavaTypeDef)stream.next()).getName();
            if (!name.equals(typeDefName)) continue;
            return true;
        }
        return false;
    }

    protected void addNonNullTypeDefNamesTo(Set<String> names) {
        ListIterator<JavaTypeDef> stream = this.typeDefs();
        while (stream.hasNext()) {
            String typeDefName = ((JavaTypeDef)stream.next()).getName();
            if (typeDefName == null) continue;
            names.add(typeDefName);
        }
    }

    public boolean specifiedPackageInfo(String typeName) {
        for (ClassRef classRef : this.getSpecifiedClassRefs()) {
            if (!classRef.isFor(typeName)) continue;
            return true;
        }
        return false;
    }

    public boolean impliedPackageInfo(String typeName) {
        for (ClassRef classRef : this.getImpliedClassRefs()) {
            if (!classRef.isFor(typeName)) continue;
            return true;
        }
        return false;
    }

    protected void validateProperties(List<IMessage> messages, IReporter reporter) {
        String configFile = this.hibernateProperties.getConfigurationFile();
        if (configFile != null && configFile.length() > 0) {
            Path path = new Path(configFile);
            try {
                IJavaProject jp = this.getJpaProject().getJavaProject();
                IPackageFragmentRoot[] pfrs = jp.getPackageFragmentRoots();
                int i = 0;
                while (i < pfrs.length) {
                    if (!pfrs[i].isArchive() && ((IContainer)pfrs[i].getResource()).findMember((IPath)path) != null) {
                        return;
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                HibernateJptPlugin.logException(e);
            }
            IJavaProject jProject = this.getJpaProject().getJavaProject();
            IResource res = null;
            if (jProject != null) {
                try {
                    IPackageFragmentRoot[] allPackageFragmentRoots;
                    IPackageFragmentRoot[] iPackageFragmentRootArray = allPackageFragmentRoots = jProject.getAllPackageFragmentRoots();
                    int n = allPackageFragmentRoots.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IContainer folder;
                        IResource sourceFolder;
                        IPackageFragmentRoot iPackageFragmentRoot = iPackageFragmentRootArray[n2];
                        if (iPackageFragmentRoot.isArchive() || !((sourceFolder = iPackageFragmentRoot.getResource()) instanceof IContainer) || (res = (folder = (IContainer)sourceFolder).findMember((IPath)path)) == null) {
                            ++n2;
                            continue;
                        }
                        break;
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            if (res != null) {
                int resType = res.getType();
                if (resType != 1) {
                    PersistenceUnit.Property prop = this.getProperty("hibernate.ejb.cfgfile");
                    IMessage message = HibernateJpaValidationMessage.buildMessage(1, "NOT_A_FILE", new String[]{configFile}, this.getResource());
                    message.setLineNo(prop.getValidationTextRange().getLineNumber());
                    messages.add(message);
                }
            } else {
                PersistenceUnit.Property prop = this.getProperty("hibernate.ejb.cfgfile");
                IMessage message = HibernateJpaValidationMessage.buildMessage(1, "CONFIG_FILE_NOT_FOUND", new String[]{configFile}, this.getResource());
                message.setLineNo(prop.getValidationTextRange().getLineNumber());
                messages.add(message);
            }
        }
    }

    public JpaJpqlQueryHelper createJpqlQueryHelper() {
        return new GenericJpaJpqlQueryHelper(this.getJpaPlatform().getJpqlGrammar());
    }

    protected Iterable<Generator> getAllJavaGenerators() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{IterableTools.concatenate((Iterable[])new Iterable[]{super.getAllJavaGenerators()}), new CompositeIterable(this.getAllPackageInfoMappingGeneratorLists())});
    }

    protected Iterable<Iterable<JavaGenerator>> getAllPackageInfoMappingGeneratorLists() {
        return new TransformationIterable(this.getClassRefPackageInfos_(), (Transformer)new Transformer<HibernatePackageInfo, Iterable<JavaGenerator>>(){

            public Iterable<JavaGenerator> transform(HibernatePackageInfo o) {
                return new SubIterableWrapper(this.transform_(o));
            }

            protected Iterable<Generator> transform_(HibernatePackageInfo o) {
                return o.getGeneratorContainer().getGenerators();
            }
        });
    }

    protected Iterable<HibernatePackageInfo> getClassRefPackageInfos_() {
        return new FilteringIterable((Iterable)new TransformationIterable((Iterable)new SubIterableWrapper(this.getClassRefs()), (Transformer)new Transformer<GenericClassRef, HibernatePackageInfo>(){

            public HibernatePackageInfo transform(GenericClassRef classRef) {
                if (classRef instanceof HibernateClassRef) {
                    return ((HibernateClassRef)classRef).getJavaPackageInfo();
                }
                return null;
            }
        }), PredicateTools.isNotNull());
    }
}

