/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.jpa.core.JpaModel;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedSecondaryTable;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.java.GenericJavaSecondaryTable;
import org.eclipse.jpt.jpa.core.resource.java.SecondaryTableAnnotation;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaProject;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJptPlugin;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateJavaSecondaryTable;
import org.jboss.tools.hibernate.jpt.core.internal.validation.HibernateJpaValidationMessage;
import org.jboss.tools.hibernate.runtime.spi.INamingStrategy;

public class HibernateJavaSecondaryTableImpl
extends GenericJavaSecondaryTable
implements HibernateJavaSecondaryTable {
    public HibernateJavaSecondaryTableImpl(JavaSpecifiedSecondaryTable.ParentAdapter parentAdapter, SecondaryTableAnnotation tableAnnotation) {
        super(parentAdapter, tableAnnotation);
    }

    public Table getDbTable() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema == null ? null : dbSchema.getTableForIdentifier(this.getDBTableName());
    }

    public HibernateJpaProject getJpaProject() {
        return (HibernateJpaProject)super.getJpaProject();
    }

    @Override
    public String getDBTableName() {
        return this.getSpecifiedDBTableName();
    }

    @Override
    public String getDefaultDBTableName() {
        return null;
    }

    @Override
    public String getSpecifiedDBTableName() {
        if (this.getSpecifiedName() == null) {
            return null;
        }
        INamingStrategy ns = this.getJpaProject().getNamingStrategy();
        if (this.getJpaProject().isNamingStrategyEnabled() && ns != null) {
            try {
                return ns.tableName(this.getSpecifiedName());
            }
            catch (Exception e) {
                IMessage m = HibernateJpaValidationMessage.buildMessage(1, "NAMING_STRATEGY_EXCEPTION", (JpaModel)this);
                HibernateJptPlugin.logException(m.getText(), e);
            }
        }
        return this.getName();
    }

    protected boolean validateAgainstDatabase(List<IMessage> messages) {
        if (!this.catalogIsResolved()) {
            messages.add(this.buildValidationMessage(JptJpaCoreValidationMessages.SECONDARY_TABLE_UNRESOLVED_CATALOG, new Object[]{new String[]{this.getCatalog(), this.getDBTableName()}, this.getCatalogValidationTextRange()}));
            return false;
        }
        if (!this.schemaIsResolved()) {
            messages.add(this.buildValidationMessage(JptJpaCoreValidationMessages.SECONDARY_TABLE_UNRESOLVED_SCHEMA, new Object[]{new String[]{this.getSchema(), this.getDBTableName()}, this.getSchemaValidationTextRange()}));
            return false;
        }
        if (!this.isResolved()) {
            messages.add(this.buildValidationMessage(JptJpaCoreValidationMessages.SECONDARY_TABLE_UNRESOLVED_NAME, new Object[]{new String[]{this.getDBTableName()}, this.getNameValidationTextRange()}));
            return false;
        }
        return true;
    }
}

