/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.java;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceModel;
import org.eclipse.jpt.common.core.internal.utility.ContentTypeTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaGeneratorContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaQueryContainer;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateAbstractJpaFactory;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateJavaTypeDefContainer;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernatePackageInfo;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.JavaPackageInfo;

public class HibernatePackageInfoImpl
extends AbstractJavaContextModel<PersistentType.Parent>
implements HibernatePackageInfo {
    protected final HibernateJavaTypeDefContainer typeDefContainer;
    protected final JavaGeneratorContainer generatorContainer;
    protected final JavaQueryContainer queryContainer;
    private JavaResourcePackage resourcePackage;
    protected String name;

    public HibernatePackageInfoImpl(PersistentType.Parent parent, JavaResourcePackage resourcePackage) {
        super((JpaContextModel)parent);
        this.resourcePackage = resourcePackage;
        this.name = resourcePackage.getName();
        this.typeDefContainer = this.getJpaFactory().buildJavaTypeDefContainer(this, this.getResourceAnnotatedElement());
        this.generatorContainer = this.buildGeneratorContainer();
        this.queryContainer = this.buildQueryContainer();
    }

    protected HibernateAbstractJpaFactory getJpaFactory() {
        return (HibernateAbstractJpaFactory)this.getJpaPlatform().getJpaFactory();
    }

    @Override
    public HibernateJavaTypeDefContainer getTypeDefContainer() {
        return this.typeDefContainer;
    }

    public IResource getResource() {
        return this.resourcePackage.getFile();
    }

    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.setName(this.resourcePackage.getName());
        this.typeDefContainer.synchronizeWithResourceModel(monitor);
        this.generatorContainer.synchronizeWithResourceModel(monitor);
        this.queryContainer.synchronizeWithResourceModel(monitor);
    }

    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.typeDefContainer.update(monitor);
        this.generatorContainer.update(monitor);
        this.queryContainer.update(monitor);
    }

    public JptResourceType getResourceType() {
        return ContentTypeTools.getResourceType((IContentType)JavaResourceCompilationUnit.PACKAGE_INFO_CONTENT_TYPE);
    }

    public JpaStructureNode.ContextType getContextType() {
        return new JpaStructureNode.ContextType((JpaStructureNode)this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    public TextRange getSelectionTextRange() {
        return this.resourcePackage.getNameTextRange();
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getSelectionTextRange();
    }

    @Override
    public JavaGeneratorContainer getGeneratorContainer() {
        return this.generatorContainer;
    }

    protected JavaGeneratorContainer buildGeneratorContainer() {
        return this.getJpaFactory().buildJavaGeneratorContainer(this);
    }

    @Override
    public JavaQueryContainer getQueryContainer() {
        return this.queryContainer;
    }

    protected JavaQueryContainer buildQueryContainer() {
        return this.getJpaFactory().buildJavaQueryContainer(this);
    }

    protected CompilationUnit buildASTRoot() {
        return this.resourcePackage.getJavaResourceCompilationUnit().buildASTRoot();
    }

    public JpaStructureNode getStructureNode(int offset) {
        this.buildASTRoot();
        if (this.containsOffset(offset)) {
            return this;
        }
        return null;
    }

    public boolean containsOffset(int offset) {
        TextRange fullTextRange = this.resourcePackage.getTextRange();
        return fullTextRange == null ? false : fullTextRange.includes(offset);
    }

    public void dispose() {
    }

    protected JpaFile getJpaFile() {
        return this.getJpaFile(this.resourcePackage.getFile());
    }

    @Override
    public JavaResourcePackage getResourcePackage() {
        return this.resourcePackage;
    }

    public JavaResourceAnnotatedElement getResourceAnnotatedElement() {
        return this.resourcePackage;
    }

    public Class<? extends JpaStructureNode> getStructureType() {
        return JavaPackageInfo.class;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        if (reporter.isCancelled()) {
            throw new ValidationCancelledException();
        }
        IFile file = this.resourcePackage.getFile();
        if (file != null && file.getProject().equals((Object)this.getJpaProject().getProject()) && this.resourcePackage instanceof SourceModel) {
            this.doValidate(messages, reporter);
        }
    }

    private void doValidate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.typeDefContainer.validate(messages, reporter);
        this.generatorContainer.validate(messages, reporter);
        this.queryContainer.validate(messages, reporter);
    }

    public Iterable<String> getCompletionProposals(int pos) {
        Iterable result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.typeDefContainer.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.generatorContainer.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.queryContainer.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        return null;
    }

    public TextRange getFullTextRange() {
        return this.resourcePackage.getTextRange();
    }

    public Iterable<? extends JpaStructureNode> getStructureChildren() {
        return IterableTools.emptyIterable();
    }

    public int getStructureChildrenSize() {
        return 0;
    }

    public void addRootStructureNodesTo(JpaFile jpaFile, Collection<JpaStructureNode> rootStructureNodes) {
    }

    public boolean supportsGenerators() {
        return false;
    }
}

