/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.java;

import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.JpaModel;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.internal.context.ContextContainerTools;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateAbstractJpaFactory;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernatePersistenceUnit;
import org.jboss.tools.hibernate.jpt.core.internal.context.Messages;
import org.jboss.tools.hibernate.jpt.core.internal.context.Parameter;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.JavaParameter;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.JavaTypeDef;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.JpaUtil;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.ParameterAnnotation;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.TypeDefAnnotation;
import org.jboss.tools.hibernate.jpt.core.internal.validation.HibernateJpaValidationMessage;

public class JavaTypeDefImpl
extends AbstractJavaContextModel<JpaContextModel>
implements JavaTypeDef,
Messages {
    protected TypeDefAnnotation typeDefAnnotation;
    protected String name;
    protected String typeClass;
    protected String defaultForTypeClass;
    protected final Vector<JavaParameter> parameters = new Vector();
    protected final ParameterContainerAdapter parameterContainerAdapter = new ParameterContainerAdapter();

    public JavaTypeDefImpl(JpaContextModel parent, TypeDefAnnotation typeDefAnnotation) {
        super(parent);
        this.typeDefAnnotation = typeDefAnnotation;
        this.name = typeDefAnnotation.getName();
        this.typeClass = typeDefAnnotation.getTypeClass();
        this.defaultForTypeClass = typeDefAnnotation.getDefaultForType();
        this.initializeParameters();
    }

    public HibernatePersistenceUnit getPersistenceUnit() {
        return (HibernatePersistenceUnit)((JpaContextModel)this.getParent()).getPersistenceUnit();
    }

    @Override
    public TypeDefAnnotation getTypeDefAnnotation() {
        return this.typeDefAnnotation;
    }

    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.setName_(this.typeDefAnnotation.getName());
        this.setTypeClass_(this.typeDefAnnotation.getTypeClass());
        this.setDefaultForTypeClass_(this.typeDefAnnotation.getDefaultForType());
        this.syncParameters(monitor);
    }

    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.getPersistenceUnit().addTypeDef(this);
        this.updateModels((Iterable)this.getParameters(), monitor);
    }

    protected HibernateAbstractJpaFactory getJpaFactory() {
        return (HibernateAbstractJpaFactory)super.getJpaFactory();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.typeDefAnnotation.setName(name);
        this.setName_(name);
    }

    protected void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    @Override
    public String getTypeClass() {
        return this.typeClass;
    }

    @Override
    public void setTypeClass(String typeClass) {
        this.typeDefAnnotation.setTypeClass(typeClass);
        this.setTypeClass_(typeClass);
    }

    protected void setTypeClass_(String typeClass) {
        String old = this.typeClass;
        this.typeClass = typeClass;
        this.firePropertyChanged("specifiedTypeClass", old, typeClass);
    }

    protected String getResourceTypeClass() {
        return this.typeDefAnnotation.getTypeClass();
    }

    @Override
    public char getTypeClassEnclosingTypeSeparator() {
        return '.';
    }

    @Override
    public String getDefaultForTypeClass() {
        return this.defaultForTypeClass;
    }

    @Override
    public void setDefaultForTypeClass(String defaultForType) {
        this.typeDefAnnotation.setDefaultForType(defaultForType);
        this.setDefaultForTypeClass_(defaultForType);
    }

    protected void setDefaultForTypeClass_(String defaultForType) {
        String old = this.defaultForTypeClass;
        this.defaultForTypeClass = defaultForType;
        this.firePropertyChanged("defaultForTypeClass", old, defaultForType);
    }

    public char getDefaultForTypeClassEnclosingTypeSeparator() {
        return '.';
    }

    public ListIterable<JavaParameter> getParameters() {
        return IterableTools.cloneLive(this.parameters);
    }

    @Override
    public int getParametersSize() {
        return this.parameters.size();
    }

    public JavaParameter addParameter() {
        return this.addParameter(this.parameters.size());
    }

    @Override
    public JavaParameter addParameter(int index) {
        ParameterAnnotation annotation = this.typeDefAnnotation.addParameter(index);
        return this.addParameter_(index, annotation);
    }

    @Override
    public void removeParameter(Parameter parameter) {
        this.removeParameter(this.parameters.indexOf(parameter));
    }

    @Override
    public void removeParameter(int index) {
        this.typeDefAnnotation.removeParameter(index);
        this.removeParameter_(index);
    }

    protected void removeParameter_(int index) {
        this.removeItemFromList(index, this.parameters, "parameters");
    }

    @Override
    public void moveParameter(int targetIndex, int sourceIndex) {
        this.typeDefAnnotation.moveParameter(targetIndex, sourceIndex);
        this.moveItemInList(targetIndex, sourceIndex, this.parameters, "parameters");
    }

    protected void initializeParameters() {
        for (ParameterAnnotation param : this.typeDefAnnotation.getParameters()) {
            this.parameters.add(this.buildParameter(param));
        }
    }

    protected JavaParameter buildParameter(ParameterAnnotation parameterAnnotation) {
        return this.getJpaFactory().buildJavaParameter(this, parameterAnnotation);
    }

    protected void syncParameters(IProgressMonitor monitor) {
        ContextContainerTools.synchronizeWithResourceModel((ContextContainerTools.Adapter)this.parameterContainerAdapter, (IProgressMonitor)monitor);
    }

    protected Iterable<ParameterAnnotation> getParameterAnnotations() {
        return this.typeDefAnnotation.getParameters();
    }

    protected void moveParameter_(int index, JavaParameter parameter) {
        this.moveItemInList(index, parameter, this.parameters, "parameters");
    }

    protected JavaParameter addParameter_(int index, ParameterAnnotation parameterAnnotation) {
        JavaParameter parameter = this.buildParameter(parameterAnnotation);
        this.addItemToList(index, parameter, this.parameters, "parameters");
        return parameter;
    }

    protected void removeParameter_(JavaParameter parameter) {
        this.removeParameter_(this.parameters.indexOf(parameter));
    }

    public TextRange getValidationTextRange() {
        return this.getSelectionTextRange();
    }

    public TextRange getSelectionTextRange() {
        return this.typeDefAnnotation.getTextRange();
    }

    @Override
    public TextRange getNameTextRange() {
        return this.typeDefAnnotation.getNameTextRange();
    }

    public TextRange getTypeClassTextRange() {
        return this.typeDefAnnotation.getTypeClassTextRange();
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        JavaTypeDef typeDef;
        ListIterator<JavaTypeDef> stream;
        super.validate(messages, reporter);
        if (StringTools.isBlank((String)this.name)) {
            messages.add(HibernateJpaValidationMessage.buildMessage(1, "NAME_CANT_BE_EMPTY", (JpaModel)this, this.getNameTextRange()));
        } else {
            stream = this.getPersistenceUnit().typeDefs();
            while (stream.hasNext()) {
                typeDef = stream.next();
                if (this == typeDef || !this.name.equals(typeDef.getName())) continue;
                messages.add(HibernateJpaValidationMessage.buildMessage(1, "TYPE_DEF_DUPLICATE_NAME", new String[]{this.name}, (JpaModel)this, this.getNameTextRange()));
                break;
            }
        }
        if (!StringTools.isBlank((String)this.typeClass)) {
            IType lwType = null;
            try {
                lwType = this.getJpaProject().getJavaProject().findType(this.typeClass);
                if (lwType == null || !lwType.isClass()) {
                    messages.add(HibernateJpaValidationMessage.buildMessage(1, "TYPE_CLASS_NOT_FOUND", new String[]{this.typeClass}, (JpaModel)this, this.getTypeClassTextRange()));
                } else if (!JpaUtil.isTypeImplementsOneOfInterfaces(this.getJpaProject().getJavaProject(), lwType, JavaTypeDef.POSSIBLE_INTERFACES).booleanValue()) {
                    messages.add(HibernateJpaValidationMessage.buildMessage(1, "USER_TYPE_INTERFACE", new String[]{this.typeClass}, (JpaModel)this, this.getTypeClassTextRange()));
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        stream = this.getPersistenceUnit().typeDefs();
        while (stream.hasNext()) {
            typeDef = stream.next();
            if (this == typeDef || !this.name.equals(typeDef.getName())) continue;
            messages.add(HibernateJpaValidationMessage.buildMessage(1, "TYPE_DEF_DUPLICATE_NAME", new String[]{this.name}, (JpaModel)this, this.getNameTextRange()));
            break;
        }
    }

    protected class ParameterContainerAdapter
    implements ContextContainerTools.Adapter<JavaParameter, ParameterAnnotation> {
        protected ParameterContainerAdapter() {
        }

        public Iterable<JavaParameter> getContextElements() {
            return JavaTypeDefImpl.this.getParameters();
        }

        public Iterable<ParameterAnnotation> getResourceElements() {
            return JavaTypeDefImpl.this.getParameterAnnotations();
        }

        public ParameterAnnotation getResourceElement(JavaParameter contextElement) {
            return contextElement.getParameterAnnotation();
        }

        public void moveContextElement(int index, JavaParameter element) {
            JavaTypeDefImpl.this.moveParameter_(index, element);
        }

        public void addContextElement(int index, ParameterAnnotation resourceElement) {
            JavaTypeDefImpl.this.addParameter_(index, resourceElement);
        }

        public void removeContextElement(JavaParameter element) {
            JavaTypeDefImpl.this.removeParameter_(element);
        }
    }
}

