/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.jpa.core.JpaModel;
import org.eclipse.jpt.jpa.core.context.NamedColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmIdMapping;
import org.eclipse.jpt.jpa.core.resource.orm.XmlId;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaProject;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJptPlugin;
import org.jboss.tools.hibernate.jpt.core.internal.context.orm.HibernateOrmColumn;
import org.jboss.tools.hibernate.jpt.core.internal.context.orm.HibernateOrmIdMapping;
import org.jboss.tools.hibernate.jpt.core.internal.validation.HibernateJpaValidationMessage;
import org.jboss.tools.hibernate.runtime.spi.INamingStrategy;

public class HibernateOrmIdMappingImpl
extends AbstractOrmIdMapping<XmlId>
implements HibernateOrmIdMapping {
    public HibernateOrmIdMappingImpl(OrmSpecifiedPersistentAttribute parent, XmlId resourceMapping) {
        super(parent, resourceMapping);
    }

    public HibernateJpaProject getJpaProject() {
        return (HibernateJpaProject)super.getJpaProject();
    }

    public String getDefaultColumnName(NamedColumn column) {
        if (this.getName() != null) {
            INamingStrategy namingStrategy = this.getJpaProject().getNamingStrategy();
            if (this.getJpaProject().isNamingStrategyEnabled() && namingStrategy != null) {
                try {
                    return namingStrategy.propertyToColumnName(this.getName());
                }
                catch (Exception e) {
                    IMessage m = HibernateJpaValidationMessage.buildMessage(1, "NAMING_STRATEGY_EXCEPTION", (JpaModel)this);
                    HibernateJptPlugin.logException(m.getText(), e);
                }
            }
        }
        return super.getDefaultColumnName(column);
    }

    public HibernateOrmColumn getColumn() {
        return (HibernateOrmColumn)this.column;
    }

    public String getPrimaryKeyColumnName() {
        return this.getColumn().getDBColumnName();
    }

    protected void validateColumn(List<IMessage> messages) {
        OrmSpecifiedPersistentAttribute pa = this.getPersistentAttribute();
        String tableName = this.column.getTableName();
        if (this.getTypeMapping().tableNameIsInvalid(tableName)) {
            if (pa.isVirtual()) {
                messages.add(this.buildValidationMessage(JptJpaCoreValidationMessages.VIRTUAL_ATTRIBUTE_COLUMN_TABLE_NOT_VALID, new Object[]{new String[]{pa.getName(), tableName, this.getColumn().getDBColumnName()}, this.column, this.column.getTableNameValidationTextRange()}));
            } else {
                messages.add(this.buildValidationMessage(JptJpaCoreValidationMessages.COLUMN_UNRESOLVED_TABLE, new Object[]{new String[]{tableName, this.getColumn().getDBColumnName()}, this.column, this.column.getTableNameValidationTextRange()}));
            }
            return;
        }
        if (!this.column.isResolved() && this.column.getDbTable() != null) {
            if (pa.isVirtual()) {
                messages.add(this.buildValidationMessage(JptJpaCoreValidationMessages.VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_NAME, new Object[]{new String[]{pa.getName(), this.getColumn().getDBColumnName()}, this.column, this.column.getTableNameValidationTextRange()}));
            } else {
                messages.add(this.buildValidationMessage(JptJpaCoreValidationMessages.COLUMN_UNRESOLVED_NAME, new Object[]{new String[]{this.getColumn().getDBColumnName()}, this.column, this.column.getTableNameValidationTextRange()}));
            }
        }
    }
}

