/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.resource.java;

import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceModel;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.CombinationIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.TypeStringExpressionConverter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.ParameterAnnotation;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.SourceParameterAnnotation;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.TypeDefAnnotation;

public class TypeDefAnnotationImpl
extends SourceAnnotation
implements TypeDefAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.hibernate.annotations.TypeDef");
    private static final DeclarationAnnotationAdapter CONTAINER_DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.hibernate.annotations.TypeDefs");
    private DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter;
    private AnnotationElementAdapter<String> nameAdapter;
    private String name;
    private DeclarationAnnotationElementAdapter<String> typeClassDeclarationAdapter;
    private AnnotationElementAdapter<String> typeClassAdapter;
    private String typeClass;
    String fullyQualifiedTypeClassName;
    private DeclarationAnnotationElementAdapter<String> defForTypeDeclarationAdapter;
    private AnnotationElementAdapter<String> defaultForTypeAdapter;
    private String defaultForType;
    String fullyQualifiedDefaultForTypeClassName;
    final Vector<ParameterAnnotation> parameters = new Vector();
    final ParametersAnnotationContainer parametersContainer = new ParametersAnnotationContainer();
    private CompilationUnit astRoot;

    public TypeDefAnnotationImpl(JavaResourceModel parent, AnnotatedElement member, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, member, daa, annotationAdapter);
        this.nameDeclarationAdapter = this.buildNameDeclarationAdapter();
        this.nameAdapter = this.buildNameAdapter();
        this.typeClassDeclarationAdapter = this.buildTypeClassDeclarationAdapter();
        this.typeClassAdapter = this.buildTypeClassAdapter();
        this.defForTypeDeclarationAdapter = this.buildDefForTypeDeclarationAdapter();
        this.defaultForTypeAdapter = this.buildDefForTypeAdapter();
    }

    public void initialize(CompilationUnit astRoot) {
        this.astRoot = astRoot;
        this.name = this.buildName(astRoot);
        this.typeClass = this.buildTypeClass(astRoot);
        this.fullyQualifiedTypeClassName = this.buildFullyQualifiedTypeClassName(astRoot);
        this.defaultForType = this.buildDefaultForType(astRoot);
        this.fullyQualifiedDefaultForTypeClassName = this.buildFullyQualifiedDefaultForTypeClassName(astRoot);
        this.parametersContainer.initializeFromContainerAnnotation(this.getAstAnnotation(astRoot));
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.astRoot = astRoot;
        this.syncName(this.buildName(astRoot));
        this.syncTypeClass(this.buildTypeClass(astRoot));
        this.syncFullyQualifiedTypeClassName(this.buildFullyQualifiedTypeClassName(astRoot));
        this.syncDefaultForType(this.buildDefaultForType(astRoot));
        this.syncFullyQualifiedDefaultForTypeClassName(this.buildFullyQualifiedDefaultForTypeClassName(astRoot));
        this.parametersContainer.synchronize(this.getAstAnnotation(astRoot));
    }

    public String getAnnotationName() {
        return "org.hibernate.annotations.TypeDef";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (ObjectTools.notEquals((Object)this.name, (Object)name)) {
            this.name = name;
            this.nameAdapter.setValue((Object)name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getElementTextRange(this.nameDeclarationAdapter, this.getAstAnnotation(this.astRoot));
    }

    protected String buildName(CompilationUnit astRoot) {
        return (String)this.nameAdapter.getValue(astRoot);
    }

    @Override
    public String getTypeClass() {
        return this.typeClass;
    }

    @Override
    public void setTypeClass(String typeClass) {
        if (ObjectTools.notEquals((Object)this.typeClass, (Object)typeClass)) {
            this.typeClass = typeClass;
            this.typeClassAdapter.setValue((Object)typeClass);
        }
    }

    private void syncTypeClass(String astTypeClass) {
        String old = this.typeClass;
        this.typeClass = astTypeClass;
        this.firePropertyChanged("typeClass", old, astTypeClass);
    }

    private String buildTypeClass(CompilationUnit astRoot) {
        return (String)this.typeClassAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getTypeClassTextRange() {
        return this.getElementTextRange(this.typeClassDeclarationAdapter, this.getAstAnnotation(this.astRoot));
    }

    @Override
    public String getFullyQualifiedTypeClassName() {
        return this.fullyQualifiedTypeClassName;
    }

    private void syncFullyQualifiedTypeClassName(String name) {
        String old = this.fullyQualifiedTypeClassName;
        this.fullyQualifiedTypeClassName = name;
        this.firePropertyChanged("fullyQualifiedTypeClassName", old, name);
    }

    private String buildFullyQualifiedTypeClassName(CompilationUnit astRoot) {
        return this.typeClass == null ? null : ASTTools.resolveFullyQualifiedName((Expression)this.typeClassAdapter.getExpression(astRoot));
    }

    @Override
    public String getDefaultForType() {
        return this.defaultForType;
    }

    @Override
    public void setDefaultForType(String defaultForType) {
        if (ObjectTools.notEquals((Object)this.defaultForType, (Object)defaultForType)) {
            this.defaultForType = defaultForType;
            this.defaultForTypeAdapter.setValue((Object)defaultForType);
        }
    }

    private void syncDefaultForType(String astDefaultForType) {
        String old = this.defaultForType;
        this.defaultForType = astDefaultForType;
        this.firePropertyChanged("defaultForType", old, astDefaultForType);
    }

    private String buildDefaultForType(CompilationUnit astRoot) {
        return (String)this.defaultForTypeAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getDefaultForTypeTextRange() {
        return this.getElementTextRange(this.defForTypeDeclarationAdapter, this.getAstAnnotation(this.astRoot));
    }

    @Override
    public String getFullyQualifiedDefaultForTypeClassName() {
        return this.fullyQualifiedDefaultForTypeClassName;
    }

    private void syncFullyQualifiedDefaultForTypeClassName(String name) {
        String old = this.fullyQualifiedDefaultForTypeClassName;
        this.fullyQualifiedDefaultForTypeClassName = name;
        this.firePropertyChanged("fullyQualifiedDefaultForTypeClassName", old, name);
    }

    private String buildFullyQualifiedDefaultForTypeClassName(CompilationUnit astRoot) {
        return this.defaultForType == null ? null : ASTTools.resolveFullyQualifiedName((Expression)this.defaultForTypeAdapter.getExpression(astRoot));
    }

    @Override
    public ListIterable<ParameterAnnotation> getParameters() {
        return this.parametersContainer.getNestedAnnotations();
    }

    @Override
    public int getParametersSize() {
        return this.parametersContainer.getNestedAnnotationsSize();
    }

    @Override
    public ParameterAnnotation parameterAt(int index) {
        return (ParameterAnnotation)this.parametersContainer.getNestedAnnotation(index);
    }

    @Override
    public ParameterAnnotation addParameter(int index) {
        return (ParameterAnnotation)this.parametersContainer.addNestedAnnotation(index);
    }

    @Override
    public void moveParameter(int targetIndex, int sourceIndex) {
        this.parametersContainer.moveNestedAnnotation(targetIndex, sourceIndex);
    }

    @Override
    public void removeParameter(int index) {
        this.parametersContainer.removeNestedAnnotation(index);
    }

    ParameterAnnotation buildParameter(int index) {
        return SourceParameterAnnotation.createParameter((JavaResourceModel)this, this.annotatedElement, this.daa, "parameters", index);
    }

    private DeclarationAnnotationElementAdapter<String> buildNameDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)"name");
    }

    private AnnotationElementAdapter<String> buildNameAdapter() {
        return this.buildStringElementAdapter(this.nameDeclarationAdapter);
    }

    private DeclarationAnnotationElementAdapter<String> buildTypeClassDeclarationAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(this.daa, "typeClass", SimpleTypeStringExpressionConverter.instance());
    }

    private AnnotationElementAdapter<String> buildTypeClassAdapter() {
        return this.buildStringElementAdapter(this.typeClassDeclarationAdapter);
    }

    private DeclarationAnnotationElementAdapter<String> buildDefForTypeDeclarationAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(this.daa, "defaultForType", TypeStringExpressionConverter.instance());
    }

    private AnnotationElementAdapter<String> buildDefForTypeAdapter() {
        return this.buildStringElementAdapter(this.defForTypeDeclarationAdapter);
    }

    public static NestableAnnotation buildTypeDefAnnotationAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement annotatedElement, int index) {
        IndexedDeclarationAnnotationAdapter idaa = TypeDefAnnotationImpl.buildTypeDefDeclarationAnnotationAdapter(index);
        IndexedAnnotationAdapter iaa = TypeDefAnnotationImpl.buildTypeDefAnnotationAdapter(annotatedElement, idaa);
        return new TypeDefAnnotationImpl((JavaResourceModel)parent, annotatedElement, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)iaa);
    }

    protected static IndexedAnnotationAdapter buildTypeDefAnnotationAdapter(AnnotatedElement annotatedElement, IndexedDeclarationAnnotationAdapter idaa) {
        return new ElementIndexedAnnotationAdapter(annotatedElement, idaa);
    }

    private static IndexedDeclarationAnnotationAdapter buildTypeDefDeclarationAnnotationAdapter(int index) {
        CombinationIndexedDeclarationAnnotationAdapter idaa = new CombinationIndexedDeclarationAnnotationAdapter(DECLARATION_ANNOTATION_ADAPTER, CONTAINER_DECLARATION_ANNOTATION_ADAPTER, index, "org.hibernate.annotations.TypeDef");
        return idaa;
    }

    class ParametersAnnotationContainer
    extends SourceModel.AnnotationContainer<ParameterAnnotation> {
        ParametersAnnotationContainer() {
            super((SourceModel)TypeDefAnnotationImpl.this);
        }

        protected String getNestedAnnotationsListName() {
            return "parameters";
        }

        protected String getElementName() {
            return "parameters";
        }

        protected String getNestedAnnotationName() {
            return "org.hibernate.annotations.Parameter";
        }

        protected ParameterAnnotation buildNestedAnnotation(int index) {
            return TypeDefAnnotationImpl.this.buildParameter(index);
        }
    }
}

