/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.validation;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jpt.common.core.internal.utility.EmptyTextRange;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.JpaModel;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJptPlugin;
import org.jboss.tools.hibernate.jpt.core.internal.context.Messages;

public class HibernateJpaValidationMessage {
    private static String[] DEFAULT_PARMS = new String[0];
    private static TextRange DEFAULT_TEXT_RANGE = EmptyTextRange.instance();
    private static final String ERROR = "error";
    private static final String WARNING = "warning";
    private static final String INFO = "info";
    private static final int NO_SEVERITY_PREFERENCE = -1;
    private static final String PROBLEM_PREFIX = "problem.";
    public static final String LEGACY_PLUGIN_ID = "org.eclipse.jpt.core";

    public static IMessage buildMessage(int defaultSeverity, String messageId, JpaModel targetObject) {
        return HibernateJpaValidationMessage.buildMessage(defaultSeverity, messageId, DEFAULT_PARMS, targetObject);
    }

    public static IMessage buildMessage(int defaultSeverity, String messageId, String[] parms, JpaModel targetObject) {
        return HibernateJpaValidationMessage.buildMessage(defaultSeverity, messageId, parms, targetObject, DEFAULT_TEXT_RANGE);
    }

    public static IMessage buildMessage(int defaultSeverity, String messageId, JpaModel targetObject, TextRange textRange) {
        return HibernateJpaValidationMessage.buildMessage(defaultSeverity, messageId, DEFAULT_PARMS, targetObject, textRange);
    }

    public static IMessage buildMessage(int defaultSeverity, String messageId, String[] parms, JpaModel targetObject, TextRange textRange) {
        return HibernateJpaValidationMessage.buildMessage(defaultSeverity, messageId, parms, targetObject.getResource(), DEFAULT_TEXT_RANGE);
    }

    public static IMessage buildMessage(int defaultSeverity, String messageId, IResource targetObject) {
        return HibernateJpaValidationMessage.buildMessage(defaultSeverity, messageId, DEFAULT_PARMS, targetObject);
    }

    public static IMessage buildMessage(int defaultSeverity, String messageId, String[] parms, IResource targetObject) {
        return HibernateJpaValidationMessage.buildMessage(defaultSeverity, messageId, parms, targetObject, DEFAULT_TEXT_RANGE);
    }

    public static IMessage buildMessage(int defaultSeverity, String messageId, IResource targetObject, TextRange textRange) {
        return HibernateJpaValidationMessage.buildMessage(defaultSeverity, messageId, DEFAULT_PARMS, targetObject, textRange);
    }

    public static IMessage buildMessage(int defaultSeverity, String messageId, String[] parms, IResource targetObject, TextRange textRange) {
        int severity = defaultSeverity;
        int severityPreference = HibernateJpaValidationMessage.getProblemSeverityPreference(targetObject, messageId);
        if (severityPreference != -1) {
            severity = severityPreference;
        }
        LocalMessage message = new LocalMessage(severity, messageId, parms, targetObject);
        message.setMarkerId(JpaProject.MARKER_TYPE);
        if (textRange == null) {
            HibernateJptPlugin.logException(new NullPointerException("Null text range for message ID: " + messageId));
        } else {
            message.setLineNo(textRange.getLineNumber());
            message.setOffset(textRange.getOffset());
            message.setLength(textRange.getLength());
        }
        return message;
    }

    private HibernateJpaValidationMessage() {
        throw new UnsupportedOperationException();
    }

    private static String appendProblemPrefix(String messageId) {
        return PROBLEM_PREFIX + messageId;
    }

    private static IEclipsePreferences getLegacyPreferences(IScopeContext context) {
        return context.getNode(LEGACY_PLUGIN_ID);
    }

    private static IEclipsePreferences getLegacyWorkspacePreferences() {
        return HibernateJpaValidationMessage.getLegacyPreferences(InstanceScope.INSTANCE);
    }

    private static String getLegacyWorkspacePreference(IProject project, String key) {
        return HibernateJpaValidationMessage.getLegacyWorkspacePreferences().get(key, null);
    }

    private static String getProblemPreference(IResource targetObject, String messageId) {
        return HibernateJpaValidationMessage.getLegacyWorkspacePreference(targetObject.getProject(), HibernateJpaValidationMessage.appendProblemPrefix(messageId));
    }

    private static int getProblemSeverityPreference(IResource targetObject, String messageId) {
        String problemPreference = HibernateJpaValidationMessage.getProblemPreference(targetObject, messageId);
        if (problemPreference == null) {
            return -1;
        }
        if (problemPreference.equals(ERROR)) {
            return 1;
        }
        if (problemPreference.equals(WARNING)) {
            return 2;
        }
        if (problemPreference.equals(INFO)) {
            return 4;
        }
        return -1;
    }

    static class LocalMessage
    extends Message {
        public LocalMessage(int severity, String message, String[] strings, Object resource) {
            super(Messages.class.getName(), severity, message, strings, resource);
        }
    }
}

