/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.ui.internal.details;

import java.util.Collection;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;
import org.eclipse.jpt.jpa.ui.details.JptJpaUiDetailsMessages;
import org.eclipse.jpt.jpa.ui.internal.details.db.CatalogCombo;
import org.eclipse.jpt.jpa.ui.internal.details.db.SchemaCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernateEntity;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernateTable;
import org.jboss.tools.hibernate.jpt.ui.internal.mappings.db.xpl.TableCombo;
import org.jboss.tools.hibernate.jpt.ui.internal.utils.PaneVisibilityEnabler;

public class HibernateTableComposite
extends Pane<HibernateEntity> {
    public HibernateTableComposite(Pane<? extends HibernateEntity> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    protected void initializeLayout(Composite container) {
        Group tableGroupPane = this.addTitledGroup(container, JptJpaUiDetailsMessages.TABLE_COMPOSITE_TABLE_SECTION);
        ModifiablePropertyValueModel<HibernateTable> subjectHolder = this.buildTableHolder();
        this.addLabel((Composite)tableGroupPane, JptJpaUiDetailsMessages.TABLE_CHOOSER_LABEL);
        this.addTableCombo((PropertyValueModel<HibernateTable>)subjectHolder, (Composite)tableGroupPane);
        this.addLabel((Composite)tableGroupPane, JptJpaUiDetailsMessages.CATALOG_CHOOSER_LABEL);
        this.addTableCombo((PropertyValueModel<HibernateTable>)subjectHolder, (Composite)tableGroupPane);
        this.addLabel((Composite)tableGroupPane, JptJpaUiDetailsMessages.SCHEMA_CHOOSER_LABEL);
        this.addTableCombo((PropertyValueModel<HibernateTable>)subjectHolder, (Composite)tableGroupPane);
        new PaneVisibilityEnabler((PropertyValueModel<Boolean>)this.buildTableEnabledHolder(), (Pane<?>)this);
    }

    protected ModifiablePropertyValueModel<HibernateTable> buildTableHolder() {
        return new PropertyAspectAdapter<HibernateEntity, HibernateTable>(this.getSubjectHolder(), new String[]{"tableIsUndefined"}){

            protected HibernateTable buildValue_() {
                return ((HibernateEntity)this.subject).tableIsUndefined() ? null : ((HibernateEntity)this.subject).getTable();
            }
        };
    }

    protected ModifiablePropertyValueModel<Boolean> buildTableEnabledHolder() {
        return new PropertyAspectAdapter<HibernateEntity, Boolean>(this.getSubjectHolder(), new String[]{"specifiedTableIsAllowed"}){

            protected Boolean buildValue_() {
                return ((HibernateEntity)this.subject).specifiedTableIsAllowed();
            }
        };
    }

    private CatalogCombo<HibernateTable> addCatalogCombo(PropertyValueModel<HibernateTable> tableHolder, Composite container) {
        return new CatalogCombo<HibernateTable>((Pane)this, tableHolder, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultCatalog");
                propertyNames.add("specifiedCatalog");
            }

            protected String getDefaultValue() {
                return ((HibernateTable)this.getSubject()).getDefaultCatalog();
            }

            protected void setValue(String value) {
                ((HibernateTable)this.getSubject()).setSpecifiedCatalog(value);
            }

            protected String getValue() {
                return ((HibernateTable)this.getSubject()).getSpecifiedCatalog();
            }
        };
    }

    private SchemaCombo<HibernateTable> addSchemaCombo(PropertyValueModel<HibernateTable> subjectHolder, Composite container) {
        return new SchemaCombo<HibernateTable>((Pane)this, subjectHolder, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultSchema");
                propertyNames.add("specifiedSchema");
            }

            protected String getDefaultValue() {
                return ((HibernateTable)this.getSubject()).getDefaultSchema();
            }

            protected void setValue(String value) {
                ((HibernateTable)this.getSubject()).setSpecifiedSchema(value);
            }

            protected String getValue() {
                return ((HibernateTable)this.getSubject()).getSpecifiedSchema();
            }

            protected SchemaContainer getDbSchemaContainer_() {
                return ((HibernateTable)this.getSubject()).getDbSchemaContainer();
            }
        };
    }

    private TableCombo<HibernateTable> addTableCombo(PropertyValueModel<HibernateTable> subjectHolder, Composite container) {
        return new TableCombo<HibernateTable>((Pane)this, subjectHolder, container){

            protected void initializeLayout(Composite container) {
                super.initializeLayout(container);
                this.comboBox.addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent e) {
                        if (comboBox.getSelectionIndex() != 0) {
                            this.setPopulating(true);
                            comboBox.setText(((HibernateTable)this.getSubject()).getName());
                            this.setPopulating(false);
                        }
                    }

                    public void focusLost(FocusEvent e) {
                        if (comboBox.getSelectionIndex() != 0) {
                            this.setPopulating(true);
                            comboBox.setText(this.getValue());
                            this.setPopulating(false);
                        }
                    }
                });
            }

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultName");
                propertyNames.add("specifiedName");
                propertyNames.add("defaultSchema");
                propertyNames.add("specifiedSchema");
                propertyNames.add("defaultCatalog");
                propertyNames.add("specifiedCatalog");
            }

            protected void propertyChanged(String propertyName) {
                super.propertyChanged(propertyName);
                if (propertyName == "defaultSchema" || propertyName == "specifiedSchema" || propertyName == "defaultCatalog" || propertyName == "specifiedCatalog") {
                    this.repopulate();
                }
            }

            protected String getDefaultValue() {
                return ((HibernateTable)this.getSubject()).getDefaultDBTableName();
            }

            protected void setValue(String value) {
                ((HibernateTable)this.getSubject()).setSpecifiedName(value);
            }

            public String getValue() {
                String specifiedName = ((HibernateTable)this.getSubject()).getSpecifiedName();
                if (specifiedName == null) {
                    return null;
                }
                String dbTableName = ((HibernateTable)this.getSubject()).getDBTableName();
                if (specifiedName.equals(dbTableName)) {
                    return specifiedName;
                }
                return String.valueOf(specifiedName) + " (" + dbTableName + ")";
            }

            @Override
            protected Schema getDbSchema_() {
                return ((HibernateTable)this.getSubject()).getDbSchema();
            }
        };
    }
}

