/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.ui.internal.mapping.details;

import java.util.Collection;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.swt.widgets.DisplayTools;
import org.eclipse.jpt.common.ui.internal.widgets.EnumFormComboViewer;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.transformer.AbstractTransformer;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.InheritanceType;
import org.eclipse.jpt.jpa.ui.details.JptJpaUiDetailsMessages;
import org.eclipse.jpt.jpa.ui.internal.details.DiscriminatorColumnComposite;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernateEntity;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateJavaEntity;
import org.jboss.tools.hibernate.jpt.ui.internal.mapping.details.HibernateDiscriminatorColumnComposite;

public abstract class HibernateAbstractInheritanceComposite<T extends HibernateEntity>
extends Pane<T> {
    protected static String DEFAULT_KEY = "?!#!?#?#?default?#?!#?!#?";
    protected static String NONE_KEY = "?!#!?#?#?none?#?!#?!#?";

    public HibernateAbstractInheritanceComposite(Pane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    protected void initializeLayout(Composite container) {
        int groupBoxMargin = this.getGroupBoxMargin();
        Composite subPane = this.addSubPane(container, 0, groupBoxMargin, 0, groupBoxMargin);
        this.addLabel(subPane, JptJpaUiDetailsMessages.INHERITANCE_COMPOSITE_STRATEGY);
        this.addStrategyCombo(container);
        ModifiablePropertyValueModel<Boolean> dvEnabled = this.buildDiscriminatorValueEnabledHolder();
        this.addLabel(subPane, JptJpaUiDetailsMessages.INHERITANCE_COMPOSITE_DISCRIMINATOR_VALUE, (PropertyValueModel)dvEnabled);
        this.addEditableCombo(subPane, (ListValueModel)this.buildDiscriminatorValueListHolder(), (ModifiablePropertyValueModel)this.buildDiscriminatorValueHolder(), (Transformer)this.buildDiscriminatorValueConverter(), (PropertyValueModel)dvEnabled);
        if (this.getSubject() instanceof HibernateJavaEntity) {
            new HibernateDiscriminatorColumnComposite(this, container);
        } else {
            new DiscriminatorColumnComposite((Pane)this, container);
        }
        this.addPrimaryKeyJoinColumnsComposite(this.addSubPane(container, 5));
    }

    protected ModifiablePropertyValueModel<Boolean> buildDiscriminatorValueEnabledHolder() {
        return new PropertyAspectAdapter<Entity, Boolean>(this.getSubjectHolder(), new String[]{"discriminatorValueIsAllowed"}){

            protected Boolean buildValue_() {
                return ((Entity)this.subject).specifiedDiscriminatorValueIsAllowed();
            }
        };
    }

    private ListValueModel<String> buildDefaultDiscriminatorListValueHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultDiscriminatorValueHolder());
    }

    private ModifiablePropertyValueModel<String> buildDefaultDiscriminatorValueHolder() {
        return new PropertyAspectAdapter<Entity, String>(this.getSubjectHolder(), new String[]{"defaultDiscriminatorValue", "discriminatorValueIsUndefined"}){

            protected String buildValue_() {
                String value = ((Entity)this.subject).getDefaultDiscriminatorValue();
                if (value == null && ((Entity)this.subject).discriminatorValueIsUndefined()) {
                    return NONE_KEY;
                }
                value = value == null ? DEFAULT_KEY : String.valueOf(DEFAULT_KEY) + value;
                return value;
            }
        };
    }

    private Transformer<String, String> buildDiscriminatorValueConverter() {
        return new AbstractTransformer<String, String>(){

            protected String transform_(String value) {
                if (HibernateAbstractInheritanceComposite.this.getSubject() == null) {
                    return null;
                }
                if (value == null) {
                    value = ((HibernateEntity)HibernateAbstractInheritanceComposite.this.getSubject()).getDefaultDiscriminatorValue();
                    if (value == null && ((HibernateEntity)HibernateAbstractInheritanceComposite.this.getSubject()).discriminatorValueIsUndefined()) {
                        value = NONE_KEY;
                    } else {
                        String string = value = value != null ? String.valueOf(DEFAULT_KEY) + value : DEFAULT_KEY;
                    }
                }
                if (value.startsWith(DEFAULT_KEY)) {
                    String defaultName = value.substring(DEFAULT_KEY.length());
                    value = defaultName.length() > 0 ? NLS.bind((String)JptCommonUiMessages.DEFAULT_WITH_ONE_PARAM, (Object)defaultName) : JptJpaUiDetailsMessages.PROVIDER_DEFAULT;
                }
                if (value.startsWith(NONE_KEY)) {
                    value = JptCommonUiMessages.NONE_SELECTED;
                }
                return value;
            }
        };
    }

    private ModifiablePropertyValueModel<String> buildDiscriminatorValueHolder() {
        return new PropertyAspectAdapter<Entity, String>(this.getSubjectHolder(), new String[]{"specifiedDiscriminatorValue"}){

            protected String buildValue_() {
                return ((Entity)this.subject).getSpecifiedDiscriminatorValue();
            }

            protected void setValue_(String value) {
                if (value != null && (value.length() == 0 || value.startsWith(DEFAULT_KEY) || value.startsWith(NONE_KEY))) {
                    value = null;
                }
                ((Entity)this.subject).setSpecifiedDiscriminatorValue(value);
            }
        };
    }

    private ListValueModel<String> buildDiscriminatorValueListHolder() {
        return this.buildDefaultDiscriminatorListValueHolder();
    }

    private EnumFormComboViewer<Entity, InheritanceType> addStrategyCombo(Composite container) {
        return new EnumFormComboViewer<Entity, InheritanceType>((Pane)this, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultInheritanceStrategy");
                propertyNames.add("specifiedInheritanceStrategy");
            }

            protected InheritanceType[] getChoices() {
                return InheritanceType.values();
            }

            protected InheritanceType getDefaultValue() {
                return ((Entity)this.getSubject()).getDefaultInheritanceStrategy();
            }

            protected String displayString(InheritanceType value) {
                switch (value) {
                    case JOINED: {
                        return JptJpaUiDetailsMessages.ABSTRACT_INHERITANCE_COMPOSITE_JOINED;
                    }
                    case SINGLE_TABLE: {
                        return JptJpaUiDetailsMessages.ABSTRACT_INHERITANCE_COMPOSITE_SINGLE_TABLE;
                    }
                    case TABLE_PER_CLASS: {
                        return JptJpaUiDetailsMessages.ABSTRACT_INHERITANCE_COMPOSITE_TABLE_PER_CLASS;
                    }
                }
                throw new IllegalStateException();
            }

            protected InheritanceType getValue() {
                return ((Entity)this.getSubject()).getSpecifiedInheritanceStrategy();
            }

            protected void setValue(InheritanceType value) {
                ((Entity)this.getSubject()).setSpecifiedInheritanceStrategy(value);
            }
        };
    }

    protected final int getGroupBoxMargin() {
        Group group = this.getWidgetFactory().createGroup((Composite)DisplayTools.getShell(), "");
        Rectangle clientArea = group.getClientArea();
        group.dispose();
        return clientArea.x + 5;
    }

    protected abstract void addPrimaryKeyJoinColumnsComposite(Composite var1);
}

