/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.ui.internal.mappings.db.xpl;

import org.eclipse.core.commands.util.Tracing;
import org.eclipse.jpt.common.ui.internal.swt.listeners.SWTListenerTools;
import org.eclipse.jpt.common.ui.internal.widgets.ComboPane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.JpaModel;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.ConnectionListener;
import org.eclipse.jpt.jpa.db.ConnectionProfile;
import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.ForeignKey;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Sequence;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.ui.internal.listeners.SWTConnectionListenerWrapper;
import org.eclipse.swt.widgets.Composite;

public abstract class DatabaseObjectCombo<T extends JpaModel>
extends ComboPane<T> {
    private ConnectionListener connectionListener;
    private PropertyChangeListener connectionProfileListener;
    public static final String UI_DB = "/debug/ui/db";

    protected DatabaseObjectCombo(Pane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    protected DatabaseObjectCombo(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    protected void initialize() {
        super.initialize();
        this.connectionListener = this.buildConnectionListener();
        this.connectionProfileListener = this.buildConnectionProfileListener();
    }

    protected ConnectionListener buildConnectionListener() {
        return new SWTConnectionListenerWrapper(this.buildConnectionListener_());
    }

    protected ConnectionListener buildConnectionListener_() {
        return new LocalConnectionListener();
    }

    protected PropertyChangeListener buildConnectionProfileListener() {
        return SWTListenerTools.wrap((PropertyChangeListener)this.buildConnectionProfileListener_());
    }

    protected PropertyChangeListener buildConnectionProfileListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                DatabaseObjectCombo.this.connectionProfileChanged(event);
            }
        };
    }

    protected void connectionProfileChanged(PropertyChangeEvent event) {
        if (event.getOldValue() != null) {
            ((ConnectionProfile)event.getOldValue()).removeConnectionListener(this.connectionListener);
        }
        if (event.getNewValue() != null) {
            ((ConnectionProfile)event.getNewValue()).addConnectionListener(this.connectionListener);
        }
        this.repopulateComboBox();
    }

    protected void engageListeners_(T subject) {
        super.engageListeners_(subject);
        subject.getJpaProject().getDataSource().addPropertyChangeListener("connectionProfile", this.connectionProfileListener);
        ConnectionProfile cp = subject.getJpaProject().getConnectionProfile();
        if (cp != null) {
            cp.addConnectionListener(this.connectionListener);
        }
    }

    protected void disengageListeners_(T subject) {
        ConnectionProfile cp = subject.getJpaProject().getConnectionProfile();
        if (cp != null) {
            cp.removeConnectionListener(this.connectionListener);
        }
        subject.getJpaProject().getDataSource().removePropertyChangeListener("connectionProfile", this.connectionProfileListener);
        super.disengageListeners_(subject);
    }

    protected final Iterable<String> getValues() {
        return this.connectionProfileIsActive() ? this.getValues_() : IterableTools.emptyIterable();
    }

    protected abstract Iterable<String> getValues_();

    protected JpaProject getJpaProject() {
        JpaModel subject = (JpaModel)this.getSubject();
        return subject == null ? null : subject.getJpaProject();
    }

    protected final ConnectionProfile getConnectionProfile() {
        JpaProject jpaProject = this.getJpaProject();
        return jpaProject == null ? null : jpaProject.getConnectionProfile();
    }

    protected final boolean connectionProfileIsActive() {
        ConnectionProfile cp = this.getConnectionProfile();
        return cp != null && cp.isActive();
    }

    protected final Database getDatabase() {
        ConnectionProfile cp = this.getConnectionProfile();
        return cp == null ? null : cp.getDatabase();
    }

    protected final void databaseChanged(Database database) {
        if (!this.comboBox.isDisposed()) {
            this.databaseChanged_(database);
        }
    }

    protected void databaseChanged_(Database database) {
    }

    protected final void catalogChanged(Catalog catalog) {
        if (!this.comboBox.isDisposed()) {
            this.catalogChanged_(catalog);
        }
    }

    protected void catalogChanged_(Catalog catalog) {
    }

    protected final void schemaChanged(Schema schema) {
        if (!this.comboBox.isDisposed()) {
            this.schemaChanged_(schema);
        }
    }

    protected void schemaChanged_(Schema schema) {
    }

    protected final void sequenceChanged(Sequence sequence) {
        if (!this.comboBox.isDisposed()) {
            this.sequenceChanged_(sequence);
        }
    }

    protected void sequenceChanged_(Sequence sequence) {
    }

    protected final void tableChanged(Table table) {
        if (!this.comboBox.isDisposed()) {
            this.tableChanged_(table);
        }
    }

    protected void tableChanged_(Table table) {
    }

    protected final void columnChanged(Column column) {
        if (!this.comboBox.isDisposed()) {
            this.columnChanged_(column);
        }
    }

    protected void columnChanged_(Column column) {
    }

    protected final void foreignKeyChanged(ForeignKey foreignKey) {
        if (!this.comboBox.isDisposed()) {
            this.foreignKeyChanged_(foreignKey);
        }
    }

    protected void foreignKeyChanged_(ForeignKey foreignKey) {
    }

    protected void log(String flag, String message) {
        Tracing.printTrace((String)flag, (String)message);
    }

    protected void repopulateComboBox() {
        super.repopulateComboBox();
    }

    protected class LocalConnectionListener
    implements ConnectionListener {
        protected LocalConnectionListener() {
        }

        public void opened(ConnectionProfile profile) {
            this.log("opened: " + profile.getName());
            DatabaseObjectCombo.this.repopulateComboBox();
        }

        public void modified(ConnectionProfile profile) {
            this.log("modified: " + profile.getName());
            DatabaseObjectCombo.this.repopulateComboBox();
        }

        public boolean okToClose(ConnectionProfile profile) {
            this.log("OK to close: " + profile.getName());
            return true;
        }

        public void aboutToClose(ConnectionProfile profile) {
            this.log("about to close: " + profile.getName());
        }

        public void closed(ConnectionProfile profile) {
            this.log("closed: " + profile.getName());
            DatabaseObjectCombo.this.repopulateComboBox();
        }

        public void databaseChanged(ConnectionProfile profile, Database database) {
            this.log("database changed: " + database.getName());
            DatabaseObjectCombo.this.databaseChanged(database);
        }

        public void catalogChanged(ConnectionProfile profile, Catalog catalog) {
            this.log("catalog changed: " + catalog.getName());
            DatabaseObjectCombo.this.catalogChanged(catalog);
        }

        public void schemaChanged(ConnectionProfile profile, Schema schema) {
            this.log("schema changed: " + schema.getName());
            DatabaseObjectCombo.this.schemaChanged(schema);
        }

        public void sequenceChanged(ConnectionProfile profile, Sequence sequence) {
            this.log("sequence changed: " + sequence.getName());
            DatabaseObjectCombo.this.sequenceChanged(sequence);
        }

        public void tableChanged(ConnectionProfile profile, Table table) {
            this.log("table changed: " + table.getName());
            DatabaseObjectCombo.this.tableChanged(table);
        }

        public void columnChanged(ConnectionProfile profile, Column column) {
            this.log("column changed: " + column.getName());
            DatabaseObjectCombo.this.columnChanged(column);
        }

        public void foreignKeyChanged(ConnectionProfile profile, ForeignKey foreignKey) {
            this.log("foreign key changed: " + foreignKey.getName());
            DatabaseObjectCombo.this.foreignKeyChanged(foreignKey);
        }

        protected void log(String message) {
            DatabaseObjectCombo.this.log(DatabaseObjectCombo.UI_DB, message);
        }
    }
}

