/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.runtime.common;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import org.jboss.tools.hibernate.runtime.common.AbstractFacade;
import org.jboss.tools.hibernate.runtime.common.IFacade;
import org.jboss.tools.hibernate.runtime.common.IFacadeFactory;
import org.jboss.tools.hibernate.runtime.common.Util;
import org.jboss.tools.hibernate.runtime.spi.IConfiguration;
import org.jboss.tools.hibernate.runtime.spi.INamingStrategy;
import org.jboss.tools.hibernate.runtime.spi.IPersistentClass;
import org.jboss.tools.hibernate.runtime.spi.IReverseEngineeringStrategy;
import org.jboss.tools.hibernate.runtime.spi.ISessionFactory;
import org.jboss.tools.hibernate.runtime.spi.ITable;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;

public abstract class AbstractConfigurationFacade
extends AbstractFacade
implements IConfiguration {
    private INamingStrategy namingStrategy;
    private HashMap<String, IPersistentClass> classMappings = null;
    private HashSet<ITable> tableMappings = null;
    private Object mappings = null;

    public AbstractConfigurationFacade(IFacadeFactory facadeFactory, Object target) {
        super(facadeFactory, target);
    }

    public String getProperty(String propertyName) {
        return (String)Util.invokeMethod(this.getTarget(), "getProperty", new Class[]{String.class}, new Object[]{propertyName});
    }

    public IConfiguration addFile(File file) {
        Util.invokeMethod(this.getTarget(), "addFile", new Class[]{File.class}, new Object[]{file});
        return this;
    }

    public void setProperty(String name, String value) {
        Util.invokeMethod(this.getTarget(), "setProperty", new Class[]{String.class, String.class}, new Object[]{name, value});
    }

    public IConfiguration setProperties(Properties properties) {
        Util.invokeMethod(this.getTarget(), "setProperties", new Class[]{Properties.class}, new Object[]{properties});
        return this;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        Util.invokeMethod(this.getTarget(), "setEntityResolver", new Class[]{EntityResolver.class}, new Object[]{entityResolver});
    }

    public Properties getProperties() {
        return (Properties)Util.invokeMethod(this.getTarget(), "getProperties", new Class[0], new Object[0]);
    }

    public void setNamingStrategy(INamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
        Object namingStrategyTarget = Util.invokeMethod(namingStrategy, "getTarget", new Class[0], new Object[0]);
        Util.invokeMethod(this.getTarget(), "setNamingStrategy", new Class[]{this.getNamingStrategyClass()}, new Object[]{namingStrategyTarget});
    }

    public void addProperties(Properties properties) {
        Util.invokeMethod(this.getTarget(), "addProperties", new Class[]{Properties.class}, new Object[]{properties});
    }

    public IConfiguration configure() {
        Util.invokeMethod(this.getTarget(), "configure", new Class[0], new Object[0]);
        this.buildMappings();
        return this;
    }

    public IConfiguration configure(Document document) {
        Util.invokeMethod(this.getTarget(), "configure", new Class[]{Document.class}, new Object[]{document});
        this.buildMappings();
        return this;
    }

    public IConfiguration configure(File file) {
        Util.invokeMethod(this.getTarget(), "configure", new Class[]{File.class}, new Object[]{file});
        this.buildMappings();
        return this;
    }

    public void addClass(IPersistentClass persistentClass) {
        if (this.mappings == null) {
            this.createMappings();
        }
        Object persistentClassTarget = ((IFacade)persistentClass).getTarget();
        Util.invokeMethod(this.mappings, "addClass", new Class[]{this.getPersistentClassClass()}, new Object[]{persistentClassTarget});
    }

    public void buildMappings() {
        Util.invokeMethod(this.getTarget(), "buildMappings", new Class[0], new Object[0]);
    }

    public ISessionFactory buildSessionFactory() {
        return this.getFacadeFactory().createSessionFactory(this.buildTargetSessionFactory());
    }

    public Iterator<IPersistentClass> getClassMappings() {
        if (this.classMappings == null) {
            this.initializeClassMappings();
        }
        return this.classMappings.values().iterator();
    }

    public void setPreferBasicCompositeIds(boolean preferBasicCompositeids) {
        if (this.getJDBCMetaDataConfigurationClass().isAssignableFrom(this.getTarget().getClass())) {
            Util.invokeMethod(this.getTarget(), "setPreferBasicCompositeIds", new Class[]{Boolean.TYPE}, new Object[]{preferBasicCompositeids});
        }
    }

    public void setReverseEngineeringStrategy(IReverseEngineeringStrategy res) {
        assert (res instanceof IFacade);
        if (this.getJDBCMetaDataConfigurationClass().isAssignableFrom(this.getTarget().getClass())) {
            Object reverseEngineeringStrategyTarget = Util.invokeMethod(res, "getTarget", new Class[0], new Object[0]);
            Util.invokeMethod(this.getTarget(), "setReverseEngineeringStrategy", new Class[]{this.getReverseEngineeringStrategyClass()}, new Object[]{reverseEngineeringStrategyTarget});
        }
    }

    public void readFromJDBC() {
        if (this.getJDBCMetaDataConfigurationClass().isAssignableFrom(this.getTarget().getClass())) {
            Util.invokeMethod(this.getTarget(), "readFromJDBC", new Class[0], new Object[0]);
        }
    }

    public IPersistentClass getClassMapping(String string) {
        if (this.classMappings == null) {
            this.initializeClassMappings();
        }
        return this.classMappings.get(string);
    }

    public INamingStrategy getNamingStrategy() {
        if (this.namingStrategy == null) {
            Object targetNamingStrategy = Util.invokeMethod(this.getTarget(), "getNamingStrategy", new Class[0], new Object[0]);
            this.namingStrategy = this.getFacadeFactory().createNamingStrategy(targetNamingStrategy);
        }
        return this.namingStrategy;
    }

    public EntityResolver getEntityResolver() {
        return (EntityResolver)Util.invokeMethod(this.getTarget(), "getEntityResolver", new Class[0], new Object[0]);
    }

    public Iterator<ITable> getTableMappings() {
        Iterator<ITable> result = null;
        if (this.getJDBCMetaDataConfigurationClass().isAssignableFrom(this.getTarget().getClass())) {
            if (this.tableMappings == null) {
                this.initializeTableMappings();
            }
            result = this.tableMappings.iterator();
        }
        return result;
    }

    public String getDefaultCatalogName() {
        return (String)Util.invokeMethod(this.buildTargetSettings(), "getDefaultCatalogName", new Class[0], new Object[0]);
    }

    public String getDefaultSchemaName() {
        return (String)Util.invokeMethod(this.buildTargetSettings(), "getDefaultSchemaName", new Class[0], new Object[0]);
    }

    protected Class<?> getNamingStrategyClass() {
        return Util.getClass(this.getNamingStrategyClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getJDBCMetaDataConfigurationClass() {
        return Util.getClass(this.getJDBCConfigurationClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getReverseEngineeringStrategyClass() {
        return Util.getClass(this.getReverseEngineeringStrategyClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getDialectFactoryClass() {
        return Util.getClass(this.getDialectFactoryClassName(), this.getFacadeFactoryClassLoader());
    }

    protected String getNamingStrategyClassName() {
        return "org.hibernate.cfg.NamingStrategy";
    }

    protected String getJDBCConfigurationClassName() {
        return "org.hibernate.cfg.JDBCMetaDataConfiguration";
    }

    protected String getReverseEngineeringStrategyClassName() {
        return "org.hibernate.cfg.reveng.ReverseEngineeringStrategy";
    }

    protected String getDialectFactoryClassName() {
        return "org.hibernate.dialect.resolver.DialectFactory";
    }

    protected Object buildTargetSessionFactory() {
        return Util.invokeMethod(this.getTarget(), "buildSessionFactory", new Class[0], new Object[0]);
    }

    protected Object buildTargetSettings() {
        return Util.invokeMethod(this.getTarget(), "buildSettings", new Class[0], new Object[0]);
    }

    protected Object buildTargetDialect() {
        return Util.invokeMethod(this.getDialectFactoryClass(), "buildDialect", new Class[]{Properties.class}, new Object[]{this.getProperties()});
    }

    protected void setClassMappings(HashMap<String, IPersistentClass> classMappings) {
        this.classMappings = classMappings;
    }

    protected void setTableMappings(HashSet<ITable> tableMappings) {
        this.tableMappings = tableMappings;
    }

    protected Object createTargetMapping() {
        return Util.invokeMethod(this.getTarget(), "buildMapping", new Class[0], new Object[0]);
    }

    protected void initializeClassMappings() {
        HashMap<String, IPersistentClass> classMappings = new HashMap<String, IPersistentClass>();
        Iterator origin = (Iterator)Util.invokeMethod(this.getTarget(), "getClassMappings", new Class[0], new Object[0]);
        while (origin.hasNext()) {
            IPersistentClass pc = this.getFacadeFactory().createPersistentClass(origin.next());
            classMappings.put(pc.getEntityName(), pc);
        }
        this.setClassMappings(classMappings);
    }

    protected void initializeTableMappings() {
        HashSet<ITable> tableMappings = new HashSet<ITable>();
        Iterator origin = (Iterator)Util.invokeMethod(this.getTarget(), "getTableMappings", new Class[0], new Object[0]);
        while (origin.hasNext()) {
            tableMappings.add(this.getFacadeFactory().createTable(origin.next()));
        }
        this.setTableMappings(tableMappings);
    }

    protected Class<?> getPersistentClassClass() {
        return Util.getClass(this.getPersistentClassClassName(), this.getFacadeFactoryClassLoader());
    }

    protected String getPersistentClassClassName() {
        return "org.hibernate.mapping.PersistentClass";
    }

    private void createMappings() {
        this.mappings = Util.invokeMethod(this.getTarget(), "createMappings", new Class[0], new Object[0]);
    }
}

