/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.runtime.v_5_0.internal;

import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.cfg.Configuration;
import org.hibernate.jpa.boot.internal.EntityManagerFactoryBuilderImpl;
import org.jboss.tools.hibernate.runtime.v_5_0.internal.HibernateToolsPersistenceProvider;

public class JPAConfiguration
extends Configuration {
    private Metadata metadata = null;
    private String persistenceUnit;

    public JPAConfiguration(String persistenceUnit, Map<Object, Object> properties) {
        this.persistenceUnit = persistenceUnit;
        if (properties != null) {
            this.getProperties().putAll(properties);
        }
    }

    public Metadata getMetadata() {
        if (this.metadata == null) {
            EntityManagerFactoryBuilderImpl entityManagerFactoryBuilder = HibernateToolsPersistenceProvider.createEntityManagerFactoryBuilder(this.persistenceUnit, this.getProperties());
            EntityManagerFactory entityManagerFactory = entityManagerFactoryBuilder.build();
            this.metadata = entityManagerFactoryBuilder.getMetadata();
            this.getProperties().putAll((Map<?, ?>)entityManagerFactory.getProperties());
        }
        return this.metadata;
    }

    public SessionFactory buildSessionFactory() {
        return this.getMetadata().buildSessionFactory();
    }

    public Configuration setProperties(Properties properties) {
        super.setProperties(properties);
        this.metadata = null;
        return this;
    }

    public Configuration addProperties(Properties properties) {
        super.addProperties(properties);
        this.metadata = null;
        return this;
    }
}

