/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.runtime.v_5_1.internal;

import java.io.File;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Properties;
import org.hibernate.Hibernate;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.JDBCMetaDataConfiguration;
import org.hibernate.cfg.JDBCReaderFactory;
import org.hibernate.cfg.reveng.DefaultDatabaseCollector;
import org.hibernate.cfg.reveng.DefaultReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.JDBCReader;
import org.hibernate.cfg.reveng.OverrideRepository;
import org.hibernate.cfg.reveng.ReverseEngineeringSettings;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.TableFilter;
import org.hibernate.cfg.reveng.dialect.MetaDataDialect;
import org.hibernate.console.HibernateConsoleRuntimeException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.connections.internal.DriverManagerConnectionProviderImpl;
import org.hibernate.engine.jdbc.dialect.spi.DatabaseMetaDataDialectResolutionInfoAdapter;
import org.hibernate.engine.jdbc.dialect.spi.DialectFactory;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfoSource;
import org.hibernate.engine.query.spi.HQLQueryPlan;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.Bag;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.List;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.PrimitiveArray;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Set;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Table;
import org.hibernate.proxy.HibernateProxyHelper;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2x.ArtifactCollector;
import org.hibernate.tool.hbm2x.Cfg2HbmTool;
import org.hibernate.tool.hbm2x.Exporter;
import org.hibernate.tool.ide.completion.HQLCodeAssist;
import org.hibernate.util.xpl.ReflectHelper;
import org.jboss.tools.hibernate.runtime.common.AbstractPersistentClassFacade;
import org.jboss.tools.hibernate.runtime.common.AbstractService;
import org.jboss.tools.hibernate.runtime.common.IFacade;
import org.jboss.tools.hibernate.runtime.common.IFacadeFactory;
import org.jboss.tools.hibernate.runtime.common.Util;
import org.jboss.tools.hibernate.runtime.spi.IArtifactCollector;
import org.jboss.tools.hibernate.runtime.spi.ICfg2HbmTool;
import org.jboss.tools.hibernate.runtime.spi.IColumn;
import org.jboss.tools.hibernate.runtime.spi.IConfiguration;
import org.jboss.tools.hibernate.runtime.spi.IDatabaseCollector;
import org.jboss.tools.hibernate.runtime.spi.IEnvironment;
import org.jboss.tools.hibernate.runtime.spi.IExporter;
import org.jboss.tools.hibernate.runtime.spi.IHQLCodeAssist;
import org.jboss.tools.hibernate.runtime.spi.IHQLQueryPlan;
import org.jboss.tools.hibernate.runtime.spi.IHibernateMappingExporter;
import org.jboss.tools.hibernate.runtime.spi.IJDBCReader;
import org.jboss.tools.hibernate.runtime.spi.INamingStrategy;
import org.jboss.tools.hibernate.runtime.spi.IOverrideRepository;
import org.jboss.tools.hibernate.runtime.spi.IPersistentClass;
import org.jboss.tools.hibernate.runtime.spi.IProperty;
import org.jboss.tools.hibernate.runtime.spi.IReverseEngineeringSettings;
import org.jboss.tools.hibernate.runtime.spi.IReverseEngineeringStrategy;
import org.jboss.tools.hibernate.runtime.spi.ISchemaExport;
import org.jboss.tools.hibernate.runtime.spi.ISessionFactory;
import org.jboss.tools.hibernate.runtime.spi.ITable;
import org.jboss.tools.hibernate.runtime.spi.ITableFilter;
import org.jboss.tools.hibernate.runtime.spi.ITypeFactory;
import org.jboss.tools.hibernate.runtime.spi.IValue;
import org.jboss.tools.hibernate.runtime.v_5_1.internal.FacadeFactoryImpl;
import org.jboss.tools.hibernate.runtime.v_5_1.internal.HibernateMappingExporterExtension;
import org.jboss.tools.hibernate.runtime.v_5_1.internal.JPAConfiguration;
import org.jboss.tools.hibernate.runtime.v_5_1.internal.OpenMappingUtilsEjb3;
import org.xml.sax.EntityResolver;

public class ServiceImpl
extends AbstractService {
    private static final String HIBERNATE_VERSION = "5.0";
    private IFacadeFactory facadeFactory = new FacadeFactoryImpl();

    public IConfiguration newAnnotationConfiguration() {
        return this.newDefaultConfiguration();
    }

    public IConfiguration newJpaConfiguration(String entityResolver, String persistenceUnit, java.util.Map<Object, Object> overrides) {
        return this.facadeFactory.createConfiguration((Object)new JPAConfiguration(persistenceUnit, overrides));
    }

    public IConfiguration newDefaultConfiguration() {
        this.getUsageTracker().trackNewConfigurationEvent(HIBERNATE_VERSION);
        return this.facadeFactory.createConfiguration((Object)new Configuration());
    }

    public IHibernateMappingExporter newHibernateMappingExporter(IConfiguration hcfg, File file) {
        assert (hcfg instanceof IFacade);
        HibernateMappingExporterExtension target = new HibernateMappingExporterExtension(this.facadeFactory, (Configuration)((IFacade)hcfg).getTarget(), file);
        return this.facadeFactory.createHibernateMappingExporter((Object)target);
    }

    public ISchemaExport newSchemaExport(IConfiguration hcfg) {
        return this.facadeFactory.createSchemaExport((Object)new SchemaExport());
    }

    public IHQLCodeAssist newHQLCodeAssist(IConfiguration hcfg) {
        IHQLCodeAssist result = null;
        if (hcfg instanceof IFacade) {
            result = this.facadeFactory.createHQLCodeAssist((Object)new HQLCodeAssist((Configuration)((IFacade)hcfg).getTarget()));
        }
        return result;
    }

    public IConfiguration newJDBCMetaDataConfiguration() {
        return this.facadeFactory.createConfiguration((Object)new JDBCMetaDataConfiguration());
    }

    public IExporter createExporter(String exporterClassName) {
        Exporter exporter = (Exporter)Util.getInstance((String)exporterClassName, (ClassLoader)this.facadeFactory.getClassLoader());
        return this.facadeFactory.createExporter((Object)exporter);
    }

    public IArtifactCollector newArtifactCollector() {
        return this.facadeFactory.createArtifactCollector((Object)new ArtifactCollector());
    }

    public IHQLQueryPlan newHQLQueryPlan(String query, boolean shallow, ISessionFactory sessionFactory) {
        SessionFactoryImpl factory = (SessionFactoryImpl)((IFacade)sessionFactory).getTarget();
        java.util.Map enabledFilters = Collections.emptyMap();
        HQLQueryPlan queryPlan = new HQLQueryPlan(query, shallow, enabledFilters, (SessionFactoryImplementor)factory);
        return this.facadeFactory.createHQLQueryPlan((Object)queryPlan);
    }

    public ITypeFactory newTypeFactory() {
        return this.facadeFactory.createTypeFactory();
    }

    public INamingStrategy newNamingStrategy(String strategyClassName) {
        try {
            return this.facadeFactory.createNamingStrategy(Class.forName(strategyClassName).newInstance());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            return null;
        }
    }

    public IOverrideRepository newOverrideRepository() {
        return this.facadeFactory.createOverrideRepository((Object)new OverrideRepository());
    }

    public ITableFilter newTableFilter() {
        return this.facadeFactory.createTableFilter((Object)new TableFilter());
    }

    public IReverseEngineeringSettings newReverseEngineeringSettings(IReverseEngineeringStrategy res) {
        assert (res instanceof IFacade);
        return this.facadeFactory.createReverseEngineeringSettings((Object)new ReverseEngineeringSettings((ReverseEngineeringStrategy)((IFacade)res).getTarget()));
    }

    public IReverseEngineeringStrategy newDefaultReverseEngineeringStrategy() {
        return this.facadeFactory.createReverseEngineeringStrategy((Object)new DefaultReverseEngineeringStrategy());
    }

    public IJDBCReader newJDBCReader(IConfiguration configuration, IReverseEngineeringStrategy strategy) {
        assert (strategy instanceof IFacade);
        JDBCReader target = JDBCReaderFactory.newJDBCReader((Properties)configuration.getProperties(), (ReverseEngineeringStrategy)((ReverseEngineeringStrategy)((IFacade)strategy).getTarget()), (ServiceRegistry)this.buildServiceRegistry(configuration.getProperties()));
        return this.facadeFactory.createJDBCReader((Object)target);
    }

    public IReverseEngineeringStrategy newReverseEngineeringStrategy(String strategyName, IReverseEngineeringStrategy delegate) {
        assert (delegate instanceof IFacade);
        ReverseEngineeringStrategy delegateTarget = (ReverseEngineeringStrategy)((IFacade)delegate).getTarget();
        Object target = this.newReverseEngineeringStrategy(strategyName, delegateTarget);
        return this.facadeFactory.createReverseEngineeringStrategy(target);
    }

    public String getReverseEngineeringStrategyClassName() {
        return ReverseEngineeringStrategy.class.getName();
    }

    public IDatabaseCollector newDatabaseCollector(IJDBCReader jdbcReader) {
        assert (jdbcReader instanceof IFacade);
        JDBCReader jdbcReaderTarget = (JDBCReader)((IFacade)jdbcReader).getTarget();
        MetaDataDialect metadataDialect = jdbcReaderTarget.getMetaDataDialect();
        return this.facadeFactory.createDatabaseCollector((Object)new DefaultDatabaseCollector(metadataDialect));
    }

    public ICfg2HbmTool newCfg2HbmTool() {
        return this.facadeFactory.createCfg2HbmTool((Object)new Cfg2HbmTool());
    }

    public IProperty newProperty() {
        return this.facadeFactory.createProperty((Object)new Property());
    }

    public ITable newTable(String name) {
        Table target = new Table(name);
        target.setPrimaryKey(new PrimaryKey(target));
        return this.facadeFactory.createTable((Object)target);
    }

    public IColumn newColumn(String string) {
        return this.facadeFactory.createColumn((Object)new Column(string));
    }

    public String newDialect(Properties properties, final Connection connection) {
        ServiceRegistry serviceRegistry = this.buildServiceRegistry(properties);
        DialectFactory dialectFactory = (DialectFactory)serviceRegistry.getService(DialectFactory.class);
        Dialect dialect = dialectFactory.buildDialect((java.util.Map)properties, new DialectResolutionInfoSource(){

            public DialectResolutionInfo getDialectResolutionInfo() {
                try {
                    return new DatabaseMetaDataDialectResolutionInfoAdapter(connection.getMetaData());
                }
                catch (SQLException sqlException) {
                    throw new HibernateConsoleRuntimeException("Unable to access java.sql.DatabaseMetaData to determine appropriate Dialect to use", (Throwable)sqlException);
                }
            }
        });
        return dialect != null ? dialect.toString() : null;
    }

    public Class<?> getDriverManagerConnectionProviderClass() {
        return DriverManagerConnectionProviderImpl.class;
    }

    public IEnvironment getEnvironment() {
        return this.facadeFactory.createEnvironment();
    }

    public IValue newSimpleValue() {
        return this.facadeFactory.createValue((Object)new SimpleValue(null));
    }

    public IValue newPrimitiveArray(IPersistentClass persistentClass) {
        assert (persistentClass instanceof IFacade);
        return this.facadeFactory.createValue((Object)new PrimitiveArray(null, (PersistentClass)((IFacade)persistentClass).getTarget()));
    }

    public IValue newArray(IPersistentClass persistentClass) {
        assert (persistentClass instanceof IFacade);
        return this.facadeFactory.createValue((Object)new Array(null, (PersistentClass)((IFacade)persistentClass).getTarget()));
    }

    public IValue newBag(IPersistentClass persistentClass) {
        assert (persistentClass instanceof IFacade);
        return this.facadeFactory.createValue((Object)new Bag(null, (PersistentClass)((IFacade)persistentClass).getTarget()));
    }

    public IValue newList(IPersistentClass persistentClass) {
        assert (persistentClass instanceof IFacade);
        return this.facadeFactory.createValue((Object)new List(null, (PersistentClass)((IFacade)persistentClass).getTarget()));
    }

    public IValue newMap(IPersistentClass persistentClass) {
        assert (persistentClass instanceof IFacade);
        return this.facadeFactory.createValue((Object)new Map(null, (PersistentClass)((IFacade)persistentClass).getTarget()));
    }

    public IValue newSet(IPersistentClass persistentClass) {
        assert (persistentClass instanceof IFacade);
        return this.facadeFactory.createValue((Object)new Set(null, (PersistentClass)((IFacade)persistentClass).getTarget()));
    }

    public IValue newManyToOne(ITable table) {
        assert (table instanceof IFacade);
        return this.facadeFactory.createValue((Object)new ManyToOne(null, (Table)((IFacade)table).getTarget()));
    }

    public IValue newOneToMany(IPersistentClass persistentClass) {
        assert (persistentClass instanceof IFacade);
        return this.facadeFactory.createValue((Object)new OneToMany(null, (PersistentClass)((IFacade)persistentClass).getTarget()));
    }

    public IValue newOneToOne(IPersistentClass persistentClass) {
        assert (persistentClass instanceof IFacade);
        return this.facadeFactory.createValue((Object)new OneToOne(null, ((PersistentClass)((IFacade)persistentClass).getTarget()).getTable(), (PersistentClass)((IFacade)persistentClass).getTarget()));
    }

    public IPersistentClass newSingleTableSubclass(IPersistentClass persistentClass) {
        assert (persistentClass instanceof IFacade);
        IPersistentClass result = this.facadeFactory.createPersistentClass((Object)new SingleTableSubclass((PersistentClass)((IFacade)persistentClass).getTarget(), null));
        ((AbstractPersistentClassFacade)result).setSuperClass(persistentClass);
        return result;
    }

    public IPersistentClass newJoinedSubclass(IPersistentClass persistentClass) {
        assert (persistentClass instanceof IFacade);
        IPersistentClass result = this.facadeFactory.createPersistentClass((Object)new JoinedSubclass((PersistentClass)((IFacade)persistentClass).getTarget(), null));
        ((AbstractPersistentClassFacade)result).setSuperClass(persistentClass);
        return result;
    }

    public IPersistentClass newSpecialRootClass(IProperty ormElement) {
        return this.facadeFactory.createSpecialRootClass(ormElement);
    }

    public IPersistentClass newRootClass() {
        return this.facadeFactory.createPersistentClass((Object)new RootClass(null));
    }

    public boolean isInitialized(Object object) {
        return Hibernate.isInitialized((Object)object);
    }

    public java.util.List<String> getJPAMappingFilePaths(String persistenceUnitName, EntityResolver entityResolver) {
        return OpenMappingUtilsEjb3.enumDocuments(persistenceUnitName, entityResolver);
    }

    public Class<?> getClassWithoutInitializingProxy(Object reflectedObject) {
        return HibernateProxyHelper.getClassWithoutInitializingProxy((Object)reflectedObject);
    }

    public ClassLoader getClassLoader() {
        return ServiceImpl.class.getClassLoader();
    }

    private ServiceRegistry buildServiceRegistry(Properties properties) {
        StandardServiceRegistryBuilder builder = new StandardServiceRegistryBuilder();
        builder.applySettings((java.util.Map)properties);
        return builder.build();
    }

    private Object newReverseEngineeringStrategy(String className, Object delegate) {
        try {
            Class clazz = ReflectHelper.classForName((String)className);
            Class revEngClass = ReflectHelper.classForName((String)"org.hibernate.cfg.reveng.ReverseEngineeringStrategy");
            Constructor constructor = clazz.getConstructor(revEngClass);
            return constructor.newInstance(delegate);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Class clazz = ReflectHelper.classForName((String)className);
                return clazz.newInstance();
            }
            catch (Exception eq) {
                throw new HibernateConsoleRuntimeException((Throwable)eq);
            }
        }
        catch (Exception e) {
            throw new HibernateConsoleRuntimeException((Throwable)e);
        }
    }
}

