/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.core;

import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.tools.jmx.core.IConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionProviderListener;
import org.jboss.tools.jmx.core.IConnectionWrapper;

public abstract class AbstractConnectionProvider
implements IConnectionProvider {
    private ArrayList<IConnectionProviderListener> listeners = new ArrayList();

    @Override
    public void addListener(IConnectionProviderListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeListener(IConnectionProviderListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireAllAdded(IConnectionWrapper[] wrappers) {
        int i = 0;
        while (i < wrappers.length) {
            this.fireAdded(wrappers[i]);
            ++i;
        }
    }

    protected void fireAllChanged(IConnectionWrapper[] wrappers) {
        int i = 0;
        while (i < wrappers.length) {
            this.fireChanged(wrappers[i]);
            ++i;
        }
    }

    protected void fireAllRemoved(IConnectionWrapper[] wrappers) {
        int i = 0;
        while (i < wrappers.length) {
            this.fireRemoved(wrappers[i]);
            ++i;
        }
    }

    public void fireAdded(IConnectionWrapper wrapper) {
        Iterator<IConnectionProviderListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            try {
                i.next().connectionAdded(wrapper);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    public void fireChanged(IConnectionWrapper wrapper) {
        Iterator<IConnectionProviderListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            try {
                i.next().connectionChanged(wrapper);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    public void fireRemoved(IConnectionWrapper wrapper) {
        Iterator<IConnectionProviderListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            try {
                i.next().connectionRemoved(wrapper);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }
}

