/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.core.providers;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.foundation.core.xml.IMemento;
import org.jboss.tools.foundation.core.xml.XMLMemento;
import org.jboss.tools.jmx.core.AbstractConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionCategory;
import org.jboss.tools.jmx.core.IConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionProviderEventEmitter;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.JMXActivator;
import org.jboss.tools.jmx.core.JMXCoreMessages;
import org.jboss.tools.jmx.core.providers.DefaultConnectionWrapper;
import org.jboss.tools.jmx.core.providers.MBeanServerConnectionDescriptor;

public class DefaultConnectionProvider
extends AbstractConnectionProvider
implements IConnectionProvider,
IConnectionProviderEventEmitter,
IConnectionCategory {
    public static final String PROVIDER_ID = "org.jboss.tools.jmx.core.providers.DefaultConnectionProvider";
    public static final String ID = "id";
    public static final String URL = "url";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String CONNECTION = "connection";
    public static final String CONNECTIONS = "connections";
    public static final String STORE_FILE = "defaultConnections.xml";
    private Map<String, DefaultConnectionWrapper> connections;

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public boolean canCreate() {
        return true;
    }

    @Override
    public boolean canDelete(IConnectionWrapper wrapper) {
        return wrapper instanceof DefaultConnectionWrapper;
    }

    public boolean canEdit(IConnectionWrapper wrapper) {
        return wrapper instanceof DefaultConnectionWrapper;
    }

    @Override
    public DefaultConnectionWrapper createConnection(Map map) throws CoreException {
        String id = (String)map.get(ID);
        String url = (String)map.get(URL);
        String username = (String)map.get(USERNAME);
        String password = (String)map.get(PASSWORD);
        MBeanServerConnectionDescriptor desc = new MBeanServerConnectionDescriptor(id, url, username, password);
        try {
            return new DefaultConnectionWrapper(desc);
        }
        catch (MalformedURLException murle) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.jmx.core", murle.getLocalizedMessage(), (Throwable)murle));
        }
    }

    @Override
    public IConnectionWrapper[] getConnections() {
        this.ensureConnectionIsInitialized();
        return this.connections.values().toArray(new IConnectionWrapper[this.connections.values().size()]);
    }

    @Override
    public void addConnection(IConnectionWrapper connection) {
        if (connection instanceof DefaultConnectionWrapper) {
            MBeanServerConnectionDescriptor descriptor = ((DefaultConnectionWrapper)connection).getDescriptor();
            this.ensureConnectionIsInitialized();
            this.connections.put(descriptor.getID(), (DefaultConnectionWrapper)connection);
            try {
                this.save();
                this.fireAdded(connection);
            }
            catch (IOException ioe) {
                Status s = new Status(4, "org.jboss.tools.jmx.core", JMXCoreMessages.DefaultConnection_ErrorAdding, (Throwable)ioe);
                JMXActivator.log((IStatus)s);
            }
        }
    }

    public DefaultConnectionWrapper getConnection(String id) {
        IConnectionWrapper[] wraps = this.getConnections();
        int i = 0;
        while (i < wraps.length) {
            if (((DefaultConnectionWrapper)wraps[i]).getDescriptor().getID().equals(id)) {
                return (DefaultConnectionWrapper)wraps[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public void removeConnection(IConnectionWrapper connection) {
        if (connection instanceof DefaultConnectionWrapper) {
            MBeanServerConnectionDescriptor descriptor = ((DefaultConnectionWrapper)connection).getDescriptor();
            if (descriptor != null) {
                this.ensureConnectionIsInitialized();
                this.connections.remove(descriptor.getID());
            }
            try {
                this.save();
                this.fireRemoved(connection);
            }
            catch (IOException ioe) {
                Status s = new Status(4, "org.jboss.tools.jmx.core", JMXCoreMessages.DefaultConnection_ErrorRemoving, (Throwable)ioe);
                JMXActivator.log((IStatus)s);
            }
        }
    }

    private void ensureConnectionIsInitialized() {
        if (this.connections == null) {
            this.loadConnections();
        }
    }

    @Override
    public void connectionChanged(IConnectionWrapper connection) {
        if (connection instanceof DefaultConnectionWrapper) {
            try {
                this.save();
                this.fireChanged(connection);
            }
            catch (IOException ioe) {
                Status s = new Status(4, "org.jboss.tools.jmx.core", JMXCoreMessages.DefaultConnection_ErrorChanging, (Throwable)ioe);
                JMXActivator.log((IStatus)s);
            }
        }
    }

    protected void loadConnections() {
        String filename = JMXActivator.getDefault().getStateLocation().append(STORE_FILE).toOSString();
        HashMap<String, DefaultConnectionWrapper> map = new HashMap<String, DefaultConnectionWrapper>();
        if (new File(filename).exists()) {
            try {
                IMemento root = XMLMemento.loadMemento((String)filename);
                IMemento[] child = root.getChildren(CONNECTION);
                int i = 0;
                while (i < child.length) {
                    String id = child[i].getString(ID);
                    String url = child[i].getString(URL);
                    String username = child[i].getString(USERNAME);
                    String password = child[i].getString(PASSWORD);
                    MBeanServerConnectionDescriptor desc = new MBeanServerConnectionDescriptor(id, url, username, password);
                    try {
                        DefaultConnectionWrapper connection = new DefaultConnectionWrapper(desc);
                        map.put(id, connection);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    ++i;
                }
                this.connections = map;
            }
            catch (IOException ioe) {
                Status s = new Status(4, "org.jboss.tools.jmx.core", JMXCoreMessages.DefaultConnection_ErrorLoading, (Throwable)ioe);
                JMXActivator.log((IStatus)s);
            }
        } else {
            this.connections = map;
        }
    }

    protected void save() throws IOException {
        String filename = JMXActivator.getDefault().getStateLocation().append(STORE_FILE).toOSString();
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(this.connections.keySet());
        Collections.sort(keys);
        XMLMemento root = XMLMemento.createWriteRoot((String)CONNECTIONS);
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            MBeanServerConnectionDescriptor descriptor;
            DefaultConnectionWrapper wrapper = this.connections.get(i.next());
            if (wrapper == null || (descriptor = wrapper.getDescriptor()) == null) continue;
            IMemento child = root.createChild(CONNECTION);
            child.putString(ID, descriptor.getID());
            child.putString(URL, descriptor.getURL());
            child.putString(USERNAME, descriptor.getUserName());
            child.putString(PASSWORD, descriptor.getPassword());
        }
        root.saveToFile(filename);
    }

    @Override
    public String getName(IConnectionWrapper wrapper) {
        MBeanServerConnectionDescriptor desc;
        if (wrapper instanceof DefaultConnectionWrapper && (desc = ((DefaultConnectionWrapper)wrapper).getDescriptor()) != null) {
            return desc.getID();
        }
        return null;
    }

    @Override
    public String getCategoryId() {
        return "IConnectionCategory.defined";
    }
}

