/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.jolokia;

import java.io.IOException;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jboss.tools.jmx.core.AbstractConnectionProvider;
import org.jboss.tools.jmx.core.ExtensionManager;
import org.jboss.tools.jmx.core.IConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.IJMXRunnable;
import org.jboss.tools.jmx.core.JMXCoreMessages;
import org.jboss.tools.jmx.core.JMXException;
import org.jboss.tools.jmx.core.tree.NodeUtils;
import org.jboss.tools.jmx.core.tree.Root;
import org.jboss.tools.jmx.jolokia.internal.Activator;
import org.jboss.tools.jmx.jolokia.internal.connection.JolokiaMBeanServerConnection;
import org.jboss.tools.jmx.jolokia.internal.model.builder.CustomClientBuilder;
import org.jolokia.client.J4pClient;
import org.jolokia.client.exception.J4pException;
import org.jolokia.client.exception.J4pRemoteException;
import org.jolokia.client.request.J4pReadRequest;
import org.jolokia.client.request.J4pReadResponse;
import org.jolokia.client.request.J4pRequest;
import org.json.simple.JSONObject;

public class JolokiaConnectionWrapper
implements IConnectionWrapper,
IAdaptable {
    public static final String ID = "id";
    public static final String URL = "url";
    public static final String HEADERS = "headers";
    public static final String IGNORE_SSL_ERRORS = "ignoreSSLErrors";
    public static final String GET_OR_POST = "getOrPost";
    private String id;
    private String url;
    private Map<String, String> headers;
    private boolean ignoreSSLErrors = false;
    private Root root;
    private boolean connected;
    private String type = "POST";
    private JolokiaMBeanServerConnection connection = null;

    public String toString() {
        return this.getName();
    }

    public MBeanServerConnection getConnection() {
        if (this.connection == null) {
            J4pClient j4pClient = this.createJ4pClient();
            this.connection = new JolokiaMBeanServerConnection(j4pClient, this.type);
        }
        return this.connection;
    }

    public synchronized void connect() throws IOException {
        this.verifyServerReachable();
        this.fireConnectionChanged();
    }

    public synchronized void disconnect() throws IOException {
        this.root = null;
        this.setConnected(false);
        this.fireConnectionChanged();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public Root getRoot() {
        return this.root;
    }

    public void loadRoot() {
        this.loadRoot((IProgressMonitor)new NullProgressMonitor());
    }

    public void loadRoot(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (this.isConnected() && this.root == null) {
            try {
                this.root = NodeUtils.createObjectNameTree((IConnectionWrapper)this, (IProgressMonitor)monitor);
            }
            catch (Throwable e) {
                Activator.pluginLog().logWarning("Failed to load JMX tree for " + this + ". " + e, e);
            }
        }
    }

    protected J4pClient createJ4pClient() {
        CustomClientBuilder jb = new CustomClientBuilder(){

            @Override
            public void clientBuilderAdditions(HttpClientBuilder builder) {
                Set defaultHeaders = JolokiaConnectionWrapper.this.headers.entrySet().stream().map(entry -> new BasicHeader((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toSet());
                builder.setDefaultHeaders(defaultHeaders);
            }

            @Override
            protected SSLConnectionSocketFactory createDefaultSSLConnectionSocketFactory() {
                if (JolokiaConnectionWrapper.this.ignoreSSLErrors) {
                    try {
                        SSLContext sslcontext = SSLContext.getInstance("TLS");
                        sslcontext.init(null, new TrustManager[]{new AcceptAllTrustManager()}, null);
                        return new JolokiaSSLConnectionSocketFactory(sslcontext, (HostnameVerifier)new NoopHostnameVerifier());
                    }
                    catch (NoSuchAlgorithmException e1) {
                        Activator.pluginLog().logWarning((Throwable)e1);
                    }
                    catch (KeyManagementException e) {
                        Activator.pluginLog().logWarning((Throwable)e);
                    }
                }
                SSLContext sslcontext = SSLContexts.createSystemDefault();
                BrowserCompatHostnameVerifier hostnameVerifier = new BrowserCompatHostnameVerifier();
                return new SSLConnectionSocketFactory(sslcontext, (X509HostnameVerifier)hostnameVerifier);
            }
        };
        jb.url(this.url);
        return jb.build();
    }

    protected void verifyServerReachable() throws IOException {
        J4pClient j4pClient = this.createJ4pClient();
        try {
            J4pReadRequest req = new J4pReadRequest("java.lang:type=Memory", new String[]{"HeapMemoryUsage"});
            J4pReadResponse resp = (J4pReadResponse)j4pClient.execute((J4pRequest)req, this.type);
            Map vals = (Map)resp.getValue();
            Object used = vals.get("used");
            Object max = vals.get("max");
            int used2 = used instanceof Number ? ((Number)used).intValue() : -1;
            int max2 = max instanceof Number ? ((Number)used).intValue() : -1;
            int cfr_ignored_0 = used2 * 100 / max2;
            this.setConnected(true);
        }
        catch (MalformedObjectNameException mone) {
            throw new IOException(mone);
        }
        catch (J4pRemoteException e) {
            throw new IOException("Remote error status=" + this.extractStatus(e.getResponse()) + " (" + e.getLocalizedMessage() + ")", e);
        }
        catch (J4pException e) {
            throw new IOException(e);
        }
    }

    private int extractStatus(JSONObject response) {
        int status = 500;
        Object val = response.get((Object)"status");
        if (val instanceof Long) {
            status = ((Long)val).intValue();
        } else {
            val = response.get((Object)"code");
            if (val instanceof Long) {
                status = ((Long)val).intValue();
            }
        }
        return status;
    }

    protected void setConnected(boolean b) {
        this.connected = b;
    }

    public void run(IJMXRunnable runnable) throws JMXException {
        try {
            runnable.run(this.getConnection());
        }
        catch (Exception ce) {
            Status s = new Status(4, "org.jboss.tools.jmx.core", JMXCoreMessages.DefaultConnection_ErrorRunningJMXCode, (Throwable)ce);
            throw new JMXException((IStatus)s);
        }
    }

    public void run(IJMXRunnable runnable, HashMap<String, String> prefs) throws JMXException {
        this.run(runnable);
    }

    public boolean canControl() {
        return true;
    }

    protected void fireConnectionChanged() {
        AbstractConnectionProvider provider = (AbstractConnectionProvider)this.getProvider();
        provider.fireChanged((IConnectionWrapper)this);
    }

    public IConnectionProvider getProvider() {
        return ExtensionManager.getProvider((String)"org.jboss.tools.jmx.jolokia.JolokiaConnectionProvider");
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof JolokiaConnectionWrapper;
    }

    public Object getAdapter(Class adapter) {
        ITabbedPropertySheetPageContributor contributor = new ITabbedPropertySheetPageContributor(){

            public String getContributorId() {
                return "org.jboss.tools.jmx.jvmmonitor.ui.JvmExplorer";
            }
        };
        if (adapter == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage(contributor);
        }
        if (adapter == ITabbedPropertySheetPageContributor.class) {
            return contributor;
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
        this.connection = null;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
        this.connection = null;
    }

    public boolean isIgnoreSSLErrors() {
        return this.ignoreSSLErrors;
    }

    public void setIgnoreSSLErrors(boolean ignoreSSLErrors) {
        this.ignoreSSLErrors = ignoreSSLErrors;
        this.connection = null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        this.connection = null;
    }

    private static class AcceptAllTrustManager
    implements X509TrustManager {
        private AcceptAllTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    private static class JolokiaSSLConnectionSocketFactory
    extends SSLConnectionSocketFactory {
        private SSLSocketFactory sockFact;

        public JolokiaSSLConnectionSocketFactory(SSLContext sslContext) {
            this(sslContext, JolokiaSSLConnectionSocketFactory.getDefaultHostnameVerifier());
        }

        @Deprecated
        public JolokiaSSLConnectionSocketFactory(SSLContext sslContext, X509HostnameVerifier hostnameVerifier) {
            this(((SSLContext)Args.notNull((Object)sslContext, (String)"SSL context")).getSocketFactory(), null, null, hostnameVerifier);
        }

        @Deprecated
        public JolokiaSSLConnectionSocketFactory(SSLContext sslContext, String[] supportedProtocols, String[] supportedCipherSuites, X509HostnameVerifier hostnameVerifier) {
            this(((SSLContext)Args.notNull((Object)sslContext, (String)"SSL context")).getSocketFactory(), supportedProtocols, supportedCipherSuites, hostnameVerifier);
        }

        @Deprecated
        public JolokiaSSLConnectionSocketFactory(SSLSocketFactory socketfactory, X509HostnameVerifier hostnameVerifier) {
            this(socketfactory, null, null, hostnameVerifier);
        }

        @Deprecated
        public JolokiaSSLConnectionSocketFactory(SSLSocketFactory socketfactory, String[] supportedProtocols, String[] supportedCipherSuites, X509HostnameVerifier hostnameVerifier) {
            this(socketfactory, supportedProtocols, supportedCipherSuites, (HostnameVerifier)hostnameVerifier);
        }

        public JolokiaSSLConnectionSocketFactory(SSLContext sslContext, HostnameVerifier hostnameVerifier) {
            this(((SSLContext)Args.notNull((Object)sslContext, (String)"SSL context")).getSocketFactory(), null, null, hostnameVerifier);
        }

        public JolokiaSSLConnectionSocketFactory(SSLContext sslContext, String[] supportedProtocols, String[] supportedCipherSuites, HostnameVerifier hostnameVerifier) {
            this(((SSLContext)Args.notNull((Object)sslContext, (String)"SSL context")).getSocketFactory(), supportedProtocols, supportedCipherSuites, hostnameVerifier);
        }

        public JolokiaSSLConnectionSocketFactory(SSLSocketFactory socketfactory, HostnameVerifier hostnameVerifier) {
            this(socketfactory, null, null, hostnameVerifier);
        }

        public JolokiaSSLConnectionSocketFactory(SSLSocketFactory socketfactory, String[] supportedProtocols, String[] supportedCipherSuites, HostnameVerifier hostnameVerifier) {
            super(socketfactory, supportedProtocols, supportedCipherSuites, hostnameVerifier);
            this.sockFact = socketfactory;
        }

        public Socket createSocket(HttpContext context) throws IOException {
            return this.sockFact.createSocket();
        }
    }
}

