/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.text.ext.hyperlink.XModelBasedHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.jsf.model.pv.JSFProjectsRoot;
import org.jboss.tools.jsf.model.pv.JSFProjectsTree;
import org.jboss.tools.jsf.text.ext.JSFExtensionsPlugin;
import org.jboss.tools.jst.web.model.pv.WebProjectNode;

public class BundleBasenameHyperlink
extends XModelBasedHyperlink {
    protected String getRequestMethod() {
        return "jsf.open.bundle";
    }

    protected Properties getRequestProperties(IRegion region) {
        Properties p = new Properties();
        String value = this.getBundleBasename(region);
        value = value == null ? "" : value;
        p.setProperty("bundle", value);
        String[] locales = this.getOrderedLocales();
        if (locales != null && locales.length > 0 && (value = locales[0]) != null) {
            p.setProperty("locale", value);
        }
        return p;
    }

    private String getBundleBasename(IRegion region) {
        if (region == null || this.getDocument() == null) {
            return null;
        }
        try {
            return this.getDocument().get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException x) {
            JSFExtensionsPlugin.log("", (Exception)((Object)x));
            return null;
        }
    }

    private XModelObject[] getBundles(XModelObject fcObject) {
        if (fcObject == null) {
            return null;
        }
        XModel fcObjectModel = fcObject.getModel();
        if (fcObjectModel == null) {
            return null;
        }
        JSFProjectsRoot jsfProjectsRoot = JSFProjectsTree.getProjectsRoot((XModel)fcObjectModel);
        if (jsfProjectsRoot == null) {
            return null;
        }
        XModelObject rbObjects = jsfProjectsRoot.getChildByPath("Resource Bundles");
        if (!(rbObjects instanceof WebProjectNode)) {
            return null;
        }
        ((WebProjectNode)rbObjects).invalidate();
        ArrayList<XModelObject> resourceBundles = new ArrayList<XModelObject>();
        XModelObject[] bundles = ((WebProjectNode)rbObjects).getTreeChildren();
        int i = 0;
        while (bundles != null && i < bundles.length) {
            String res = XModelObjectLoaderUtil.getResourcePath((XModelObject)bundles[i]);
            if (res != null) {
                resourceBundles.add(bundles[i]);
            }
            ++i;
        }
        return resourceBundles.size() == 0 ? null : resourceBundles.toArray(new XModelObject[0]);
    }

    private String[] getBundles() {
        XModelObject fcObject = EclipseResourceUtil.createObjectForResource((IResource)this.getFile());
        if (fcObject == null) {
            return null;
        }
        ArrayList<String> bundlesPaths = new ArrayList<String>();
        XModelObject[] bundles = this.getBundles(fcObject);
        int i = 0;
        while (bundles != null && i < bundles.length) {
            String res = XModelObjectLoaderUtil.getResourcePath((XModelObject)bundles[i]);
            if (res != null) {
                res = res.substring(1, res.length() - 11).replace('/', '.');
                bundlesPaths.add(res);
            }
            ++i;
        }
        return bundlesPaths.size() == 0 ? null : bundlesPaths.toArray(new String[0]);
    }

    private String[] getOrderedLocales() {
        XModelObject fcObject = EclipseResourceUtil.createObjectForResource((IResource)this.getFile());
        if (fcObject == null) {
            return null;
        }
        return this.getOrderedLocales(fcObject);
    }

    private String[] getOrderedLocales(XModelObject fcObject) {
        Locale defJavaLocale;
        String defLocale;
        if (fcObject == null) {
            return null;
        }
        HashSet<String> allLocales = new HashSet<String>();
        ArrayList<String> supportedLocales = new ArrayList<String>();
        ArrayList<String> langs = new ArrayList<String>();
        XModelObject lcObject = fcObject != null ? fcObject.getChildByPath("application/Locale Config") : null;
        String string = defLocale = lcObject != null ? lcObject.getAttributeValue("default-locale") : null;
        if (defLocale != null && defLocale.trim().length() > 0) {
            String locale = defLocale.trim().replace('-', '_');
            if (!allLocales.contains(locale)) {
                allLocales.add(locale);
                supportedLocales.add(locale);
            }
            if (locale.indexOf(95) != -1) {
                if (!allLocales.contains(locale = locale.replace('_', '-'))) {
                    allLocales.add(locale);
                    supportedLocales.add(locale);
                }
                if (!allLocales.contains(locale = locale.substring(0, locale.indexOf(45)))) {
                    allLocales.add(locale);
                    supportedLocales.add(locale);
                }
            }
        }
        if ((defJavaLocale = Locale.getDefault()) != null && defJavaLocale.getLanguage() != null && defJavaLocale.getLanguage().length() > 0) {
            String locale;
            if (defJavaLocale.getCountry() != null && defJavaLocale.getCountry().length() > 0) {
                locale = String.valueOf(defJavaLocale.getLanguage()) + '_' + defJavaLocale.getCountry();
                if (!allLocales.contains(locale)) {
                    allLocales.add(locale);
                    supportedLocales.add(locale);
                }
                if (!allLocales.contains(locale = String.valueOf(defJavaLocale.getLanguage()) + '-' + defJavaLocale.getCountry())) {
                    allLocales.add(locale);
                    supportedLocales.add(locale);
                }
            }
            if (!allLocales.contains(locale = defJavaLocale.getLanguage())) {
                allLocales.add(locale);
                langs.add(locale);
            }
        }
        XModelObject[] lcChildren = lcObject != null ? lcObject.getChildren() : null;
        int i = 0;
        while (lcChildren != null && i < lcChildren.length) {
            String supLocale = lcChildren[i].getAttributeValue("supported-locale");
            if (supLocale != null && supLocale.trim().length() > 0) {
                String locale = supLocale.trim().replace('-', '_');
                if (!allLocales.contains(locale)) {
                    allLocales.add(locale);
                    supportedLocales.add(locale);
                }
                if (locale.indexOf(95) != -1) {
                    if (!allLocales.contains(locale = locale.replace('_', '-'))) {
                        allLocales.add(locale);
                        supportedLocales.add(locale);
                    }
                    if (!allLocales.contains(locale = locale.substring(0, locale.indexOf(45)))) {
                        allLocales.add(locale);
                        langs.add(locale);
                    }
                }
            }
            ++i;
        }
        supportedLocales.addAll(langs);
        supportedLocales.add("");
        return supportedLocales.toArray(new String[0]);
    }

    public String getHyperlinkText() {
        String baseName = this.getBundleBasename(this.getHyperlinkRegion());
        if (baseName == null) {
            return MessageFormat.format(Messages.OpenA, Messages.Bundle);
        }
        return MessageFormat.format(Messages.OpenBundle, baseName);
    }
}

